/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.AbstractTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;

class SubTextGraphics
extends AbstractTextGraphics {
    private final TextGraphics underlyingTextGraphics;
    private final TerminalPosition topLeft;
    private final TerminalSize writableAreaSize;

    SubTextGraphics(TextGraphics underlyingTextGraphics, TerminalPosition topLeft, TerminalSize writableAreaSize) {
        this.underlyingTextGraphics = underlyingTextGraphics;
        this.topLeft = topLeft;
        this.writableAreaSize = writableAreaSize;
    }

    private TerminalPosition project(int column, int row) {
        return this.topLeft.withRelative(column, row);
    }

    @Override
    public TextGraphics setCharacter(int columnIndex, int rowIndex, TextCharacter textCharacter) {
        TerminalSize writableArea = this.getSize();
        if (columnIndex < 0 || columnIndex >= writableArea.getColumns() || rowIndex < 0 || rowIndex >= writableArea.getRows()) {
            return this;
        }
        TerminalPosition projectedPosition = this.project(columnIndex, rowIndex);
        this.underlyingTextGraphics.setCharacter(projectedPosition, textCharacter);
        return this;
    }

    @Override
    public TerminalSize getSize() {
        return this.writableAreaSize;
    }

    @Override
    public TextCharacter getCharacter(int column, int row) {
        TerminalPosition projectedPosition = this.project(column, row);
        return this.underlyingTextGraphics.getCharacter(projectedPosition.getColumn(), projectedPosition.getRow());
    }
}

