/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class BorderLayout
implements LayoutManager {
    private static final List<Location> AUTO_ASSIGN_ORDER = Collections.unmodifiableList(Arrays.asList(Location.CENTER, Location.TOP, Location.BOTTOM, Location.LEFT, Location.RIGHT));

    @Override
    public TerminalSize getPreferredSize(List<Component> components) {
        EnumMap<Location, Component> layout = this.makeLookupMap(components);
        int preferredHeight = (layout.containsKey(Location.TOP) ? layout.get(Location.TOP).getPreferredSize().getRows() : 0) + Math.max(layout.containsKey(Location.LEFT) ? layout.get(Location.LEFT).getPreferredSize().getRows() : 0, Math.max(layout.containsKey(Location.CENTER) ? layout.get(Location.CENTER).getPreferredSize().getRows() : 0, layout.containsKey(Location.RIGHT) ? layout.get(Location.RIGHT).getPreferredSize().getRows() : 0)) + (layout.containsKey(Location.BOTTOM) ? layout.get(Location.BOTTOM).getPreferredSize().getRows() : 0);
        int preferredWidth = Math.max((layout.containsKey(Location.LEFT) ? layout.get(Location.LEFT).getPreferredSize().getColumns() : 0) + (layout.containsKey(Location.CENTER) ? layout.get(Location.CENTER).getPreferredSize().getColumns() : 0) + (layout.containsKey(Location.RIGHT) ? layout.get(Location.RIGHT).getPreferredSize().getColumns() : 0), Math.max(layout.containsKey(Location.TOP) ? layout.get(Location.TOP).getPreferredSize().getColumns() : 0, layout.containsKey(Location.BOTTOM) ? layout.get(Location.BOTTOM).getPreferredSize().getColumns() : 0));
        return new TerminalSize(preferredWidth, preferredHeight);
    }

    @Override
    public void doLayout(TerminalSize area, List<Component> components) {
        EnumMap<Location, Component> layout = this.makeLookupMap(components);
        int availableHorizontalSpace = area.getColumns();
        int availableVerticalSpace = area.getRows();
        int topComponentHeight = 0;
        int leftComponentWidth = 0;
        if (layout.containsKey(Location.TOP)) {
            Component topComponent = layout.get(Location.TOP);
            topComponentHeight = Math.min(topComponent.getPreferredSize().getRows(), availableVerticalSpace);
            topComponent.setPosition(TerminalPosition.TOP_LEFT_CORNER);
            topComponent.setSize(new TerminalSize(availableHorizontalSpace, topComponentHeight));
            availableVerticalSpace -= topComponentHeight;
        }
        if (layout.containsKey(Location.BOTTOM)) {
            Component bottomComponent = layout.get(Location.BOTTOM);
            int bottomComponentHeight = Math.min(bottomComponent.getPreferredSize().getRows(), availableVerticalSpace);
            bottomComponent.setPosition(new TerminalPosition(0, area.getRows() - bottomComponentHeight));
            bottomComponent.setSize(new TerminalSize(availableHorizontalSpace, bottomComponentHeight));
            availableVerticalSpace -= bottomComponentHeight;
        }
        if (layout.containsKey(Location.LEFT)) {
            Component leftComponent = layout.get(Location.LEFT);
            leftComponentWidth = Math.min(leftComponent.getPreferredSize().getColumns(), availableHorizontalSpace);
            leftComponent.setPosition(new TerminalPosition(0, topComponentHeight));
            leftComponent.setSize(new TerminalSize(leftComponentWidth, availableVerticalSpace));
            availableHorizontalSpace -= leftComponentWidth;
        }
        if (layout.containsKey(Location.RIGHT)) {
            Component rightComponent = layout.get(Location.RIGHT);
            int rightComponentWidth = Math.min(rightComponent.getPreferredSize().getColumns(), availableHorizontalSpace);
            rightComponent.setPosition(new TerminalPosition(area.getColumns() - rightComponentWidth, topComponentHeight));
            rightComponent.setSize(new TerminalSize(rightComponentWidth, availableVerticalSpace));
            availableHorizontalSpace -= rightComponentWidth;
        }
        if (layout.containsKey(Location.CENTER)) {
            Component centerComponent = layout.get(Location.CENTER);
            centerComponent.setPosition(new TerminalPosition(leftComponentWidth, topComponentHeight));
            centerComponent.setSize(new TerminalSize(availableHorizontalSpace, availableVerticalSpace));
        }
        for (Component component : components) {
            if (layout.values().contains(component)) continue;
            component.setPosition(TerminalPosition.TOP_LEFT_CORNER);
            component.setSize(TerminalSize.ZERO);
        }
    }

    private EnumMap<Location, Component> makeLookupMap(List<Component> components) {
        EnumMap<Location, Component> map = new EnumMap<Location, Component>(Location.class);
        ArrayList<Component> unassignedComponents = new ArrayList<Component>();
        for (Component component : components) {
            if (component.getLayoutData() instanceof Location) {
                map.put((Location)component.getLayoutData(), component);
                continue;
            }
            unassignedComponents.add(component);
        }
        block1: for (Component component : unassignedComponents) {
            for (Location location : AUTO_ASSIGN_ORDER) {
                if (map.containsKey(location)) continue;
                map.put(location, component);
                continue block1;
            }
        }
        return map;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    public static enum Location implements LayoutData
    {
        CENTER,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

