/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import java.util.List;

public class LinearLayout
implements LayoutManager {
    private final Direction direction;
    private int spacing;
    private boolean changed;

    public static LayoutData createLayoutData(Alignment alignment) {
        return new LinearLayoutData(alignment);
    }

    public LinearLayout() {
        this(Direction.VERTICAL);
    }

    public LinearLayout(Direction direction) {
        this.direction = direction;
        this.spacing = direction == Direction.HORIZONTAL ? 1 : 0;
        this.changed = true;
    }

    public LinearLayout setSpacing(int spacing) {
        this.spacing = spacing;
        this.changed = true;
        return this;
    }

    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public TerminalSize getPreferredSize(List<Component> components) {
        if (this.direction == Direction.VERTICAL) {
            return this.getPreferredSizeVertically(components);
        }
        return this.getPreferredSizeHorizontally(components);
    }

    private TerminalSize getPreferredSizeVertically(List<Component> components) {
        int maxWidth = 0;
        int height = 0;
        for (Component component : components) {
            TerminalSize preferredSize = component.getPreferredSize();
            if (maxWidth < preferredSize.getColumns()) {
                maxWidth = preferredSize.getColumns();
            }
            height += preferredSize.getRows();
        }
        return new TerminalSize(maxWidth, Math.max(0, height += this.spacing * (components.size() - 1)));
    }

    private TerminalSize getPreferredSizeHorizontally(List<Component> components) {
        int maxHeight = 0;
        int width = 0;
        for (Component component : components) {
            TerminalSize preferredSize = component.getPreferredSize();
            if (maxHeight < preferredSize.getRows()) {
                maxHeight = preferredSize.getRows();
            }
            width += preferredSize.getColumns();
        }
        return new TerminalSize(Math.max(0, width += this.spacing * (components.size() - 1)), maxHeight);
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void doLayout(TerminalSize area, List<Component> components) {
        if (this.direction == Direction.VERTICAL) {
            this.doVerticalLayout(area, components);
        } else {
            this.doHorizontalLayout(area, components);
        }
        this.changed = false;
    }

    private void doVerticalLayout(TerminalSize area, List<Component> components) {
        int remainingVerticalSpace = area.getRows();
        int availableHorizontalSpace = area.getColumns();
        for (Component component : components) {
            if (remainingVerticalSpace <= 0) {
                component.setPosition(TerminalPosition.TOP_LEFT_CORNER);
                component.setSize(TerminalSize.ZERO);
                continue;
            }
            Alignment alignment = Alignment.Beginning;
            LayoutData layoutData = component.getLayoutData();
            if (layoutData instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData).alignment;
            }
            TerminalSize preferredSize = component.getPreferredSize();
            TerminalSize decidedSize = new TerminalSize(Math.min(availableHorizontalSpace, preferredSize.getColumns()), Math.min(remainingVerticalSpace, preferredSize.getRows()));
            if (alignment == Alignment.Fill) {
                decidedSize = decidedSize.withColumns(availableHorizontalSpace);
                alignment = Alignment.Beginning;
            }
            TerminalPosition position = component.getPosition();
            position = position.withRow(area.getRows() - remainingVerticalSpace);
            switch (alignment) {
                case End: {
                    position = position.withColumn(availableHorizontalSpace - decidedSize.getColumns());
                    break;
                }
                case Center: {
                    position = position.withColumn((availableHorizontalSpace - decidedSize.getColumns()) / 2);
                    break;
                }
                default: {
                    position = position.withColumn(0);
                }
            }
            component.setPosition(position);
            component.setSize(component.getSize().with(decidedSize));
            remainingVerticalSpace -= decidedSize.getRows() + this.spacing;
        }
    }

    private void doHorizontalLayout(TerminalSize area, List<Component> components) {
        int remainingHorizontalSpace = area.getColumns();
        int availableVerticalSpace = area.getRows();
        for (Component component : components) {
            if (remainingHorizontalSpace <= 0) {
                component.setPosition(TerminalPosition.TOP_LEFT_CORNER);
                component.setSize(TerminalSize.ZERO);
                continue;
            }
            Alignment alignment = Alignment.Beginning;
            LayoutData layoutData = component.getLayoutData();
            if (layoutData instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData).alignment;
            }
            TerminalSize preferredSize = component.getPreferredSize();
            TerminalSize decidedSize = new TerminalSize(Math.min(remainingHorizontalSpace, preferredSize.getColumns()), Math.min(availableVerticalSpace, preferredSize.getRows()));
            if (alignment == Alignment.Fill) {
                decidedSize = decidedSize.withRows(availableVerticalSpace);
                alignment = Alignment.Beginning;
            }
            TerminalPosition position = component.getPosition();
            position = position.withColumn(area.getColumns() - remainingHorizontalSpace);
            switch (alignment) {
                case End: {
                    position = position.withRow(availableVerticalSpace - decidedSize.getRows());
                    break;
                }
                case Center: {
                    position = position.withRow((availableVerticalSpace - decidedSize.getRows()) / 2);
                    break;
                }
                default: {
                    position = position.withRow(0);
                }
            }
            component.setPosition(position);
            component.setSize(component.getSize().with(decidedSize));
            remainingHorizontalSpace -= decidedSize.getColumns() + this.spacing;
        }
    }

    private static class LinearLayoutData
    implements LayoutData {
        private final Alignment alignment;

        public LinearLayoutData(Alignment alignment) {
            this.alignment = alignment;
        }
    }

    public static enum Alignment {
        Beginning,
        Center,
        End,
        Fill;

    }
}

