/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.ActionListDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import java.util.List;

public class ActionListDialog
extends DialogWindow {
    ActionListDialog(String title, String description, TerminalSize actionListPreferredSize, boolean canCancel, List<Runnable> actions) {
        super(title);
        if (actions.isEmpty()) {
            throw new IllegalStateException("ActionListDialog needs at least one item");
        }
        ActionListBox listBox = new ActionListBox(actionListPreferredSize);
        for (final Runnable action : actions) {
            listBox.addItem(action.toString(), new Runnable(){

                @Override
                public void run() {
                    action.run();
                    ActionListDialog.this.close();
                }
            });
        }
        Panel mainPanel = new Panel();
        mainPanel.setLayoutManager(new GridLayout(1).setLeftMarginSize(1).setRightMarginSize(1));
        if (description != null) {
            mainPanel.addComponent(new Label(description));
            mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        }
        ((ActionListBox)listBox.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false))).addTo(mainPanel);
        mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        if (canCancel) {
            Panel buttonPanel = new Panel();
            buttonPanel.setLayoutManager(new GridLayout(2).setHorizontalSpacing(1));
            buttonPanel.addComponent((Component)new Button(LocalizedString.Cancel.toString(), new Runnable(){

                @Override
                public void run() {
                    ActionListDialog.this.onCancel();
                }
            }).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.CENTER, GridLayout.Alignment.CENTER, true, false)));
            ((Panel)buttonPanel.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false))).addTo(mainPanel);
        }
        this.setComponent(mainPanel);
    }

    private void onCancel() {
        this.close();
    }

    public static void showDialog(WindowBasedTextGUI textGUI, String title, String description, Runnable ... items) {
        ActionListDialog actionListDialog = (ActionListDialog)((ActionListDialogBuilder)((ActionListDialogBuilder)new ActionListDialogBuilder().setTitle(title)).setDescription(description)).addActions(items).build();
        actionListDialog.showDialog(textGUI);
    }
}

