/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.table.Table;
import com.googlecode.lanterna.gui2.table.TableCellRenderer;

public class DefaultTableCellRenderer<V>
implements TableCellRenderer<V> {
    @Override
    public TerminalSize getPreferredSize(Table<V> table, V cell, int columnIndex, int rowIndex) {
        String[] lines = this.getContent(cell);
        int maxWidth = 0;
        for (String line : lines) {
            int length = TerminalTextUtils.getColumnWidth(line);
            if (maxWidth >= length) continue;
            maxWidth = length;
        }
        return new TerminalSize(maxWidth, lines.length);
    }

    @Override
    public void drawCell(Table<V> table, V cell, int columnIndex, int rowIndex, TextGUIGraphics textGUIGraphics) {
        ThemeDefinition themeDefinition = table.getThemeDefinition();
        if (table.getSelectedColumn() == columnIndex && table.getSelectedRow() == rowIndex || table.getSelectedRow() == rowIndex && !table.isCellSelection()) {
            if (table.isFocused()) {
                textGUIGraphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                textGUIGraphics.applyThemeStyle(themeDefinition.getSelected());
            }
            textGUIGraphics.fill(' ');
        } else {
            textGUIGraphics.applyThemeStyle(themeDefinition.getNormal());
        }
        String[] lines = this.getContent(cell);
        int rowCount = 0;
        for (String line : lines) {
            textGUIGraphics.putString(0, rowCount++, line);
        }
    }

    private String[] getContent(V cell) {
        String[] lines = cell == null ? new String[]{""} : cell.toString().split("\r?\n");
        return lines;
    }
}

