/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.TerminalTextGraphics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTerminal
implements Terminal {
    private final List<TerminalResizeListener> resizeListeners = new ArrayList<TerminalResizeListener>();
    private TerminalSize lastKnownSize = null;

    protected AbstractTerminal() {
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        if (listener != null) {
            this.resizeListeners.add(listener);
        }
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        if (listener != null) {
            this.resizeListeners.remove(listener);
        }
    }

    protected synchronized void onResized(int columns, int rows) {
        this.onResized(new TerminalSize(columns, rows));
    }

    protected synchronized void onResized(TerminalSize newSize) {
        if (this.lastKnownSize == null || !this.lastKnownSize.equals(newSize)) {
            this.lastKnownSize = newSize;
            for (TerminalResizeListener resizeListener : this.resizeListeners) {
                resizeListener.onResized(this, this.lastKnownSize);
            }
        }
    }

    @Override
    public TextGraphics newTextGraphics() throws IOException {
        return new TerminalTextGraphics(this);
    }
}

