/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.SwingTerminalImplementation;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;

public class SwingTerminal
extends JComponent
implements IOSafeTerminal {
    private final SwingTerminalImplementation terminalImplementation;

    public SwingTerminal() {
        this(new TerminalScrollController.Null());
    }

    public SwingTerminal(TerminalScrollController scrollController) {
        this(TerminalEmulatorDeviceConfiguration.getDefault(), SwingTerminalFontConfiguration.getDefault(), TerminalEmulatorColorConfiguration.getDefault(), scrollController);
    }

    public SwingTerminal(TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration) {
        this(null, deviceConfiguration, fontConfiguration, colorConfiguration);
    }

    public SwingTerminal(TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration) {
        this(initialTerminalSize, deviceConfiguration, fontConfiguration, colorConfiguration, new TerminalScrollController.Null());
    }

    public SwingTerminal(TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        this(null, deviceConfiguration, fontConfiguration, colorConfiguration, scrollController);
    }

    public SwingTerminal(TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        if (deviceConfiguration == null) {
            deviceConfiguration = TerminalEmulatorDeviceConfiguration.getDefault();
        }
        if (fontConfiguration == null) {
            fontConfiguration = SwingTerminalFontConfiguration.getDefault();
        }
        if (colorConfiguration == null) {
            colorConfiguration = TerminalEmulatorColorConfiguration.getDefault();
        }
        this.terminalImplementation = new SwingTerminalImplementation(this, fontConfiguration, initialTerminalSize, deviceConfiguration, colorConfiguration, scrollController);
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        return this.terminalImplementation.getPreferredSize();
    }

    @Override
    protected synchronized void paintComponent(Graphics componentGraphics) {
        this.terminalImplementation.paintComponent(componentGraphics);
    }

    @Override
    public void enterPrivateMode() {
        this.terminalImplementation.enterPrivateMode();
    }

    @Override
    public void exitPrivateMode() {
        this.terminalImplementation.exitPrivateMode();
    }

    @Override
    public void clearScreen() {
        this.terminalImplementation.clearScreen();
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.terminalImplementation.setCursorPosition(x, y);
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        this.terminalImplementation.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.terminalImplementation.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.terminalImplementation.setCursorVisible(visible);
    }

    @Override
    public void putCharacter(char c) {
        this.terminalImplementation.putCharacter(c);
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.terminalImplementation.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.terminalImplementation.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.terminalImplementation.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.terminalImplementation.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.terminalImplementation.setBackgroundColor(color);
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.terminalImplementation.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout, TimeUnit timeoutUnit) {
        return this.terminalImplementation.enquireTerminal(timeout, timeoutUnit);
    }

    @Override
    public void bell() {
        this.terminalImplementation.bell();
    }

    @Override
    public void flush() {
        this.terminalImplementation.flush();
    }

    @Override
    public void close() {
        this.terminalImplementation.close();
    }

    @Override
    public KeyStroke pollInput() {
        return this.terminalImplementation.pollInput();
    }

    @Override
    public KeyStroke readInput() {
        return this.terminalImplementation.readInput();
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.terminalImplementation.newTextGraphics();
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.terminalImplementation.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.terminalImplementation.removeResizeListener(listener);
    }
}

