/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.sugar.util.EncodingException;
import jonelo.sugar.util.GeneralString;

public class CombinedChecksum
extends AbstractChecksum {
    private Vector algorithms;

    public CombinedChecksum() {
        this.init();
    }

    public CombinedChecksum(String[] stringArray, boolean bl) throws NoSuchAlgorithmException {
        this.init();
        this.setAlgorithms(stringArray, bl);
    }

    private void init() {
        this.algorithms = new Vector();
        this.length = 0L;
        this.filename = null;
        this.separator = " ";
        this.encoding = "hex";
    }

    public void addAlgorithm(String string, boolean bl) throws NoSuchAlgorithmException {
        AbstractChecksum abstractChecksum = JacksumAPI.getChecksumInstance((String)string, (boolean)bl);
        abstractChecksum.setName(string);
        this.algorithms.add(abstractChecksum);
    }

    public void setAlgorithms(String[] stringArray, boolean bl) throws NoSuchAlgorithmException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addAlgorithm(stringArray[i], bl);
        }
    }

    public void reset() {
        for (int i = 0; i < this.algorithms.size(); ++i) {
            ((AbstractChecksum)this.algorithms.elementAt(i)).reset();
        }
        this.length = 0L;
    }

    public void update(int n) {
        for (int i = 0; i < this.algorithms.size(); ++i) {
            ((AbstractChecksum)this.algorithms.elementAt(i)).update(i);
        }
        ++this.length;
    }

    public void update(byte by) {
        for (int i = 0; i < this.algorithms.size(); ++i) {
            ((AbstractChecksum)this.algorithms.elementAt(i)).update(by);
        }
        ++this.length;
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < this.algorithms.size(); ++i) {
            ((AbstractChecksum)this.algorithms.elementAt(i)).update(byArray, n, n2);
        }
        this.length += (long)n2;
    }

    public void update(byte[] byArray) {
        for (int i = 0; i < this.algorithms.size(); ++i) {
            ((AbstractChecksum)this.algorithms.elementAt(i)).update(byArray);
        }
        this.length += (long)byArray.length;
    }

    public byte[] getByteArray() {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        for (int i = 0; i < this.algorithms.size(); ++i) {
            byte[] byArray = ((AbstractChecksum)this.algorithms.elementAt(i)).getByteArray();
            vector.add(byArray);
            n += byArray.length;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray2 = (byte[])vector.elementAt(i);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public void firstFormat(StringBuffer stringBuffer) {
        int n;
        GeneralString.replaceAllStrings(stringBuffer, "#FINGERPRINT", "#CHECKSUM");
        this.setEncoding(this.encoding);
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = stringBuffer.toString();
        if (string.indexOf("#CHECKSUM{i}") > -1 || string.indexOf("#ALGONAME{i}") > -1) {
            for (n = 0; n < this.algorithms.size(); ++n) {
                StringBuffer stringBuffer3 = new StringBuffer(string);
                GeneralString.replaceAllStrings(stringBuffer3, "#CHECKSUM{i}", ((AbstractChecksum)this.algorithms.elementAt(n)).getFormattedValue());
                GeneralString.replaceAllStrings(stringBuffer3, "#ALGONAME{i}", ((AbstractChecksum)this.algorithms.elementAt(n)).getName());
                stringBuffer2.append(stringBuffer3);
                if (this.algorithms.size() <= 1) continue;
                stringBuffer2.append("\n");
            }
        } else {
            stringBuffer2.append(string);
        }
        if (stringBuffer2.toString().indexOf("#CHECKSUM{") > -1) {
            for (n = 0; n < this.algorithms.size(); ++n) {
                GeneralString.replaceAllStrings(stringBuffer2, "#CHECKSUM{" + n + "}", ((AbstractChecksum)this.algorithms.elementAt(n)).getFormattedValue());
            }
        }
        if (stringBuffer2.toString().indexOf("#ALGONAME{") > -1) {
            for (n = 0; n < this.algorithms.size(); ++n) {
                GeneralString.replaceAllStrings(stringBuffer2, "#ALGONAME{" + n + "}", ((AbstractChecksum)this.algorithms.elementAt(n)).getName());
            }
        }
        stringBuffer.setLength(0);
        stringBuffer.append(stringBuffer2.toString());
    }

    public void setEncoding(String string) throws EncodingException {
        for (int i = 0; i < this.algorithms.size(); ++i) {
            ((AbstractChecksum)this.algorithms.elementAt(i)).setEncoding(string);
        }
        this.encoding = ((AbstractChecksum)this.algorithms.elementAt(0)).getEncoding();
    }
}

