/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.File;
import net.filebot.Settings;

public enum ApplicationFolder {
    UserHome(Settings.isMacSandbox() ? System.getProperty("UserHome") : System.getProperty("user.home")),
    AppData(System.getProperty("application.dir", UserHome.resolve(".filebot").getPath())),
    TemporaryFiles(System.getProperty("java.io.tmpdir")),
    Cache(System.getProperty("application.cache", AppData.resolve("cache").getPath()));

    private final File path;

    private ApplicationFolder(String path) {
        this.path = new File(path);
    }

    public File get() {
        return this.path;
    }

    public File resolve(String name) {
        return new File(this.path, name);
    }
}

