/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.filebot.CacheManager;
import net.filebot.CacheType;
import net.filebot.CachedResource;
import net.filebot.Logging;
import net.sf.ehcache.Element;
import org.w3c.dom.Document;

public class Cache {
    public static final Duration ONE_DAY = Duration.ofHours(18L);
    public static final Duration ONE_WEEK = Duration.ofDays(6L);
    public static final Duration ONE_MONTH = Duration.ofDays(24L);
    private final net.sf.ehcache.Cache cache;
    private final CacheType cacheType;

    public static Cache getCache(String name, CacheType type) {
        return CacheManager.getInstance().getCache(name.toLowerCase() + "_" + type.ordinal(), type);
    }

    public <T> CachedResource<T, byte[]> bytes(T key, CachedResource.Transform<T, URL> resource) {
        return new CachedResource<T, byte[]>(key, resource, CachedResource.fetchIfModified(), CachedResource.getBytes(), byte[].class::cast, ONE_DAY, this);
    }

    public <T> CachedResource<T, byte[]> bytes(T key, CachedResource.Transform<T, URL> resource, CachedResource.Transform<InputStream, InputStream> decompressor) {
        return new CachedResource<T, byte[]>(key, resource, CachedResource.fetchIfModified(), CachedResource.getBytes(decompressor), byte[].class::cast, ONE_DAY, this);
    }

    public <T> CachedResource<T, String> text(T key, CachedResource.Transform<T, URL> resource) {
        return new CachedResource<T, String>(key, resource, CachedResource.fetchIfModified(), CachedResource.getText(StandardCharsets.UTF_8), String.class::cast, ONE_DAY, this);
    }

    public <T> CachedResource<T, Document> xml(T key, CachedResource.Transform<T, URL> resource) {
        return new CachedResource<T, Document>(key, resource, CachedResource.fetchIfModified(), CachedResource.validateXml(CachedResource.getText(StandardCharsets.UTF_8)), CachedResource.getXml(String.class::cast), ONE_DAY, this);
    }

    public <T> CachedResource<T, Object> json(T key, CachedResource.Transform<T, URL> resource) {
        return new CachedResource<T, Object>(key, resource, CachedResource.fetchIfModified(), CachedResource.validateJson(CachedResource.getText(StandardCharsets.UTF_8)), CachedResource.getJson(String.class::cast), ONE_DAY, this);
    }

    public Cache(net.sf.ehcache.Cache cache, CacheType cacheType) {
        this.cache = cache;
        this.cacheType = cacheType;
    }

    public String getName() {
        return this.cache.getName();
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public Object get(Object key) {
        try {
            return this.getElementValue(this.cache.get(key));
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Cache get: %s => %s", key, e));
            return null;
        }
    }

    public Object computeIf(Object key, Predicate<Element> condition, Compute<?> compute) throws Exception {
        Element element = null;
        try {
            element = this.cache.get(key);
            if (element != null && !condition.test(element)) {
                return this.getElementValue(element);
            }
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Cache computeIf: %s => %s", key, e));
        }
        Object value = compute.apply(element);
        this.put(key, value);
        return value;
    }

    public Object computeIfAbsent(Object key, Compute<?> compute) throws Exception {
        return this.computeIf(key, it -> it == null, compute);
    }

    public void put(Object key, Object value) {
        try {
            this.cache.put(this.createElement(key, value));
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Cache put: %s => %s", key, e));
        }
    }

    protected Object getElementValue(Element element) {
        return element == null ? null : element.getObjectValue();
    }

    protected Element createElement(Object key, Object value) {
        return new Element(key, value);
    }

    public void remove(Object key) {
        try {
            this.cache.remove(key);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Cache remove: %s => %s", key, e));
        }
    }

    public void flush() {
        try {
            this.cache.flush();
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Cache flush: %s => %s", this.cache.getName(), e));
        }
    }

    public String toString() {
        return this.cache.getName();
    }

    public static Predicate<Element> isStale(Duration expirationTime) {
        return element -> System.currentTimeMillis() - element.getLatestOfCreationAndUpdateTime() > expirationTime.toMillis();
    }

    public <V> TypedCache<V> typed(Function<Object, V> read, Function<V, Object> write) {
        return new TypedCache<V>(this.cache, this.cacheType, read, write);
    }

    public <V> TypedCache<V> cast(Class<V> cls) {
        return new TypedCache<Object>(this.cache, this.cacheType, it -> cls.cast(it), it -> it);
    }

    public <V> TypedCache<List<V>> castList(Class<V> cls) {
        return new TypedCache<List<V>>(this.cache, this.cacheType, it -> it == null ? null : Arrays.stream((Object[])it).map(cls::cast).collect(Collectors.toList()), it -> it == null ? null : it.toArray());
    }

    public static class TypedCache<V>
    extends Cache {
        private final Function<Object, V> read;
        private final Function<V, Object> write;

        public TypedCache(net.sf.ehcache.Cache cache, CacheType cacheType, Function<Object, V> read, Function<V, Object> write) {
            super(cache, cacheType);
            this.read = read;
            this.write = write;
        }

        public V get(Object key) {
            return (V)super.get(key);
        }

        public V computeIf(Object key, Predicate<Element> condition, Compute<?> compute) throws Exception {
            return (V)super.computeIf(key, condition, compute);
        }

        public V computeIfAbsent(Object key, Compute<?> compute) throws Exception {
            return (V)super.computeIfAbsent(key, compute);
        }

        @Override
        protected Object getElementValue(Element element) {
            return this.read.apply(super.getElementValue(element));
        }

        @Override
        protected Element createElement(Object key, Object value) {
            return super.createElement(key, this.write.apply(value));
        }
    }

    @FunctionalInterface
    public static interface Compute<R> {
        public R apply(Element var1) throws Exception;
    }
}

