/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import net.filebot.ApplicationFolder;
import net.filebot.History;
import net.filebot.Logging;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;

public final class HistorySpooler {
    private static final HistorySpooler instance = new HistorySpooler();
    private final File persistentHistoryFile = ApplicationFolder.AppData.resolve("history.xml");
    private int sessionHistoryTotalSize = 0;
    private int persistentHistoryTotalSize = -1;
    private boolean persistentHistoryEnabled = true;
    private final History sessionHistory = new History();

    public static HistorySpooler getInstance() {
        return instance;
    }

    /*
     * Exception decompiling
     */
    public synchronized History getCompleteHistory() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void commit() {
        if (this.sessionHistory.sequences().isEmpty() || !this.persistentHistoryEnabled) {
            return;
        }
        try (FileChannel channel = FileChannel.open(this.persistentHistoryFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             FileLock lock = channel.lock();){
            History history = new History();
            if (channel.size() > 0L) {
                try {
                    channel.position(0L);
                    history = History.importHistory(new CloseShieldInputStream(Channels.newInputStream(channel)));
                }
                catch (Exception e) {
                    Logging.debug.log(Level.SEVERE, "Failed to read history file", e);
                }
            }
            history.addAll(this.sessionHistory.sequences());
            channel.position(0L);
            History.exportHistory(history, new CloseShieldOutputStream(Channels.newOutputStream(channel)));
            channel.truncate(channel.position());
            this.sessionHistory.clear();
            this.persistentHistoryTotalSize = history.totalSize();
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to write history file", e);
        }
    }

    public synchronized void append(Map<File, File> elements) {
        this.append(elements.entrySet());
    }

    public synchronized void append(Iterable<Map.Entry<File, File>> elements) {
        ArrayList<History.Element> sequence = new ArrayList<History.Element>();
        for (Map.Entry<File, File> element : elements) {
            sequence.add(new History.Element(element.getKey().getName(), element.getValue().getPath(), element.getKey().getParentFile()));
        }
        if (sequence.size() > 0) {
            this.sessionHistory.add(sequence);
            this.sessionHistoryTotalSize += sequence.size();
        }
    }

    public synchronized void append(History importHistory) {
        this.sessionHistory.merge(importHistory);
    }

    public synchronized History getSessionHistory() {
        return new History(this.sessionHistory.sequences());
    }

    public synchronized int getSessionHistoryTotalSize() {
        return this.sessionHistoryTotalSize;
    }

    public synchronized int getPersistentHistoryTotalSize() {
        return this.persistentHistoryTotalSize;
    }

    public synchronized void setPersistentHistoryEnabled(boolean persistentHistoryEnabled) {
        this.persistentHistoryEnabled = persistentHistoryEnabled;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(HistorySpooler.getInstance()::commit, "HistorySpoolerShutdownHook"));
    }
}

