/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.util.RegularExpressions;

public class Language
implements Serializable {
    private final String iso_639_1;
    private final String iso_639_3;
    private final String iso_639_2B;
    private final String tag;
    private final String[] names;
    public static final Comparator<Language> ALPHABETIC_ORDER = Comparator.comparing(Language::getName, String::compareToIgnoreCase);

    public Language(String iso_639_1, String iso_639_3, String iso_639_2B, String tag, String[] names) {
        this.iso_639_1 = iso_639_1;
        this.iso_639_3 = iso_639_3;
        this.iso_639_2B = iso_639_2B;
        this.tag = tag;
        this.names = (String[])names.clone();
    }

    public String getCode() {
        return this.iso_639_1;
    }

    public String getISO2() {
        return this.iso_639_1;
    }

    public String getISO3() {
        return this.iso_639_3;
    }

    public String getISO3B() {
        return this.iso_639_2B;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.names[0];
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(Arrays.asList(this.names));
    }

    public String toString() {
        return this.iso_639_3;
    }

    public Locale getLocale() {
        Locale locale = Locale.forLanguageTag(this.tag);
        if (locale == null || locale.getLanguage().isEmpty()) {
            return new Locale(this.iso_639_1);
        }
        return locale;
    }

    public boolean matches(String code) {
        return Stream.concat(Stream.of(this.iso_639_1, this.iso_639_2B, this.iso_639_3, this.tag), Stream.of(this.names)).anyMatch(c -> c.equalsIgnoreCase(code));
    }

    public Language clone() {
        return new Language(this.iso_639_1, this.iso_639_3, this.iso_639_2B, this.tag, this.names);
    }

    public static Language getLanguage(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        try {
            String[] values = RegularExpressions.TAB.split(Language.getProperty(code), 4);
            return new Language(code, values[0], values[1], values[2], RegularExpressions.TAB.split(values[3]));
        }
        catch (Exception e) {
            Logging.debug.finest(Logging.cause(e));
            return null;
        }
    }

    public static List<Language> getLanguages(String ... codes) {
        return Arrays.stream(codes).map(Language::getLanguage).collect(Collectors.toList());
    }

    public static Language getLanguage(Locale locale) {
        return locale == null ? null : Language.findLanguage(locale.getLanguage());
    }

    public static Language findLanguage(String language) {
        return Language.availableLanguages().stream().filter(it -> it.matches(language)).findFirst().orElse(null);
    }

    public static String getStandardLanguageCode(String lang) {
        try {
            return Language.findLanguage(lang).getISO3();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Language> availableLanguages() {
        String languages = Language.getProperty("languages.ui");
        return Language.getLanguages(RegularExpressions.SPACE.split(languages));
    }

    public static List<Language> commonLanguages() {
        String languages = Language.getProperty("languages.common");
        return Language.getLanguages(RegularExpressions.SPACE.split(languages));
    }

    public static List<Language> preferredLanguages() {
        Stream<String> codes = Stream.of(Locale.ENGLISH, Locale.getDefault()).map(Locale::getLanguage);
        codes = Stream.concat(codes, RegularExpressions.SPACE.splitAsStream(Language.getProperty("languages.common"))).distinct();
        return codes.map(Language::getLanguage).collect(Collectors.toList());
    }

    private static String getProperty(String key) {
        return ResourceBundle.getBundle(Language.class.getName()).getString(key);
    }
}

