/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.filebot.ApplicationFolder;
import net.filebot.Cache;
import net.filebot.CacheManager;
import net.filebot.CacheType;
import net.filebot.HistorySpooler;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.cli.ArgumentBean;
import net.filebot.cli.ArgumentProcessor;
import net.filebot.cli.CmdlineException;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.platform.windows.WinAppUtilities;
import net.filebot.ui.FileBotMenuBar;
import net.filebot.ui.GettingStartedStage;
import net.filebot.ui.MainFrame;
import net.filebot.ui.NotificationHandler;
import net.filebot.ui.PanelBuilder;
import net.filebot.ui.SinglePanelFrame;
import net.filebot.ui.SupportDialog;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.PreferencesMap;
import net.filebot.util.XPathUtilities;
import net.filebot.util.ui.SwingEventBus;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;
import org.kohsuke.args4j.CmdLineException;
import org.w3c.dom.Document;

public class Main {
    public static void main(String[] argv) {
        try {
            ArgumentBean args = new ArgumentBean(argv);
            if (args.printHelp()) {
                Logging.log.info(String.format("%s%n%n%s", Settings.getApplicationIdentifier(), args.usage()));
                System.exit(0);
            }
            if (args.printVersion()) {
                Logging.log.info(String.join((CharSequence)" / ", Settings.getApplicationIdentifier(), Settings.getJavaRuntimeIdentifier(), Settings.getSystemIdentifier()));
                System.exit(0);
            }
            if (args.clearCache() || args.clearUserData()) {
                if (args.clearUserData()) {
                    Logging.log.info("Reset preferences");
                    Settings.forPackage(Main.class).clear();
                }
                if (args.clearCache()) {
                    if (System.console() == null) {
                        Logging.log.severe("`filebot -clear-cache` has been disabled due to abuse.");
                        System.exit(1);
                    }
                    Logging.log.info("Clear cache");
                    for (File folder : FileUtilities.getChildren(ApplicationFolder.Cache.get(), FileUtilities.FOLDERS)) {
                        Logging.log.fine("* Delete " + folder);
                        FileUtilities.delete(folder);
                    }
                }
                System.exit(0);
            }
            Settings.setApplicationArguments(args);
            Main.initializeSystemProperties(args);
            Main.initializeLogging(args);
            CacheManager.getInstance();
            Main.initializeSecurityManager();
            HistorySpooler.getInstance().setPersistentHistoryEnabled(Settings.useRenameHistory());
            if (args.runCLI()) {
                int status = new ArgumentProcessor().run(args);
                System.exit(status);
            }
            if (GraphicsEnvironment.isHeadless()) {
                Logging.log.info(String.format("%s / %s (headless)%n%n%s", Settings.getApplicationIdentifier(), Settings.getJavaRuntimeIdentifier(), args.usage()));
                System.exit(1);
            }
            SwingUtilities.invokeLater(() -> {
                Main.startUserInterface(args);
                SwingUI.newSwingWorker(() -> Main.onStart(args)).execute();
            });
        }
        catch (CmdLineException e) {
            Logging.log.severe(e::getMessage);
            System.exit(1);
        }
        catch (Throwable e) {
            Logging.debug.log(Level.SEVERE, "Error during startup: " + ExceptionUtilities.getRootCause(e), e);
            System.exit(1);
        }
    }

    private static void onStart(ArgumentBean args) {
        List<File> files = args.getFiles(false);
        if (files.size() > 0) {
            SwingEventBus.getInstance().post(new FileTransferable(files));
        }
        try {
            SwingUI.initJavaFX();
        }
        catch (Throwable e) {
            Logging.log.log(Level.SEVERE, "Failed to initialize JavaFX. Please install JavaFX.", e);
        }
        if (!"skip".equals(System.getProperty("application.help"))) {
            try {
                Main.checkGettingStarted();
            }
            catch (Throwable e) {
                Logging.debug.log(Level.WARNING, "Failed to show Getting Started help", e);
            }
        }
        if (!"skip".equals(System.getProperty("application.update"))) {
            try {
                Main.checkUpdate();
            }
            catch (Throwable e) {
                Logging.debug.log(Level.WARNING, "Failed to check for updates", e);
            }
        }
    }

    private static void startUserInterface(ArgumentBean args) {
        if (Settings.isExecutableJar()) {
            SwingUI.setNimbusLookAndFeel();
        } else {
            SwingUI.setSystemLookAndFeel();
        }
        PanelBuilder[] panels = PanelBuilder.defaultSequence();
        if (args.mode != null && (panels = (PanelBuilder[])Arrays.stream(panels).filter(p -> p.getName().matches(args.mode)).toArray(PanelBuilder[]::new)).length == 0) {
            throw new CmdlineException("Illegal mode: " + args.mode);
        }
        JFrame frame = panels.length > 1 ? new MainFrame(panels) : new SinglePanelFrame(panels[0]);
        try {
            Main.restoreWindowBounds(frame, Settings.forPackage(MainFrame.class));
        }
        catch (Exception e) {
            frame.setLocation(120, 80);
        }
        frame.addWindowListener(SwingUI.windowClosed(evt -> {
            evt.getWindow().setVisible(false);
            HistorySpooler.getInstance().commit();
            SupportDialog.maybeShow();
            System.exit(0);
        }));
        if (Settings.isMacApp()) {
            MacAppUtilities.initializeApplication();
            MacAppUtilities.setWindowCanFullScreen(frame);
            MacAppUtilities.setDefaultMenuBar(FileBotMenuBar.createHelp());
            MacAppUtilities.setOpenFileHandler(openFiles -> SwingEventBus.getInstance().post(new FileTransferable((Collection<File>)openFiles)));
        } else if (Settings.isUbuntuApp()) {
            frame.setIconImages(ResourceManager.getApplicationIcons());
        } else if (Settings.isWindowsApp()) {
            if (!Settings.isAppStore()) {
                WinAppUtilities.setAppUserModelID(Settings.getApplicationUserModelID());
            }
            frame.setIconImages(ResourceManager.getApplicationIcons());
        } else {
            frame.setIconImages(ResourceManager.getApplicationIcons());
        }
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    private static void checkUpdate() throws Exception {
        int currentRev;
        Cache cache = Cache.getCache(Settings.getApplicationName(), CacheType.Persistent);
        Document dom = cache.xml("update.url", s -> new URL(Settings.getApplicationProperty(s))).expire(Cache.ONE_WEEK).retry(0).get();
        Map<String, String> update = XPathUtilities.streamElements(dom.getFirstChild()).collect(Collectors.toMap(n -> n.getNodeName(), n -> n.getTextContent().trim()));
        int latestRev = Integer.parseInt(update.get("revision"));
        if (latestRev > (currentRev = Settings.getApplicationRevisionNumber()) && currentRev > 0) {
            SwingUtilities.invokeLater(() -> {
                JDialog dialog = new JDialog((Window)JFrame.getFrames()[0], (String)update.get("title"), Dialog.ModalityType.APPLICATION_MODAL);
                JPanel pane = new JPanel(new MigLayout("fill, nogrid, insets dialog"));
                dialog.setContentPane(pane);
                pane.add((Component)new JLabel(ResourceManager.getIcon("window.icon.medium")), "aligny top");
                pane.add((Component)new JLabel((String)update.get("message")), "aligny top, gap 10, wrap paragraph:push");
                pane.add((Component)SwingUI.newButton("Download", ResourceManager.getIcon("dialog.continue"), evt -> {
                    SwingUI.openURI((String)update.get("download"));
                    dialog.setVisible(false);
                }), "tag ok");
                pane.add((Component)SwingUI.newButton("Details", ResourceManager.getIcon("action.report"), evt -> SwingUI.openURI((String)update.get("discussion"))), "tag help2");
                pane.add((Component)SwingUI.newButton("Ignore", ResourceManager.getIcon("dialog.cancel"), evt -> dialog.setVisible(false)), "tag cancel");
                dialog.pack();
                dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
                dialog.setVisible(true);
            });
        }
    }

    private static void checkGettingStarted() throws Exception {
        PreferencesMap.PreferencesEntry<String> started = Settings.forPackage(Main.class).entry("getting.started").defaultValue("0");
        if ("0".equals(started.getValue())) {
            started.setValue("1");
            started.flush();
            SwingUtilities.invokeLater(GettingStartedStage::start);
        }
    }

    private static void restoreWindowBounds(JFrame window, Settings settings) {
        window.addWindowListener(SwingUI.windowClosed(evt -> {
            if (!SwingUI.isMaximized(window)) {
                settings.put("window.x", String.valueOf(window.getX()));
                settings.put("window.y", String.valueOf(window.getY()));
                settings.put("window.width", String.valueOf(window.getWidth()));
                settings.put("window.height", String.valueOf(window.getHeight()));
            }
        }));
        int x = Integer.parseInt(settings.get("window.x"));
        int y = Integer.parseInt(settings.get("window.y"));
        int width = Integer.parseInt(settings.get("window.width"));
        int height = Integer.parseInt(settings.get("window.height"));
        window.setBounds(x, y, width, height);
    }

    private static void initializeSecurityManager() {
        try {
            Policy.setPolicy(new Policy(){

                @Override
                public boolean implies(ProtectionDomain domain, Permission permission) {
                    return true;
                }

                @Override
                public PermissionCollection getPermissions(CodeSource codesource) {
                    return new Permissions();
                }
            });
            System.setSecurityManager(new SecurityManager());
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static void initializeSystemProperties(ArgumentBean args) {
        System.setProperty("http.agent", String.format("%s %s", Settings.getApplicationName(), Settings.getApplicationVersion()));
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "60000");
        System.setProperty("swing.crossplatformlaf", "javax.swing.plaf.nimbus.NimbusLookAndFeel");
        System.setProperty("grape.root", ApplicationFolder.AppData.resolve("grape").getPath());
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        if (args.unixfs) {
            System.setProperty("unixfs", "true");
        }
        if (args.disableExtendedAttributes) {
            System.setProperty("useExtendedFileAttributes", "false");
            System.setProperty("useCreationDate", "false");
        }
    }

    public static void initializeLogging(ArgumentBean args) throws IOException {
        ApplicationFolder.TemporaryFiles.get().mkdirs();
        ApplicationFolder.AppData.get().mkdirs();
        if (args.runCLI()) {
            Logging.log.setLevel(args.getLogLevel());
        } else {
            Logging.log.setLevel(Level.INFO);
            Logging.log.addHandler(new NotificationHandler(Settings.getApplicationName()));
            try {
                StreamHandler errorLogHandler = Logging.createSimpleFileHandler(ApplicationFolder.AppData.resolve("error.log"), Level.WARNING);
                Logging.log.addHandler(errorLogHandler);
                Logging.debug.addHandler(errorLogHandler);
            }
            catch (Exception e) {
                Logging.log.log(Level.WARNING, "Failed to initialize error log", e);
            }
        }
        if (args.logFile != null) {
            StreamHandler logFileHandler = Logging.createLogFileHandler(args.getLogFile(), args.logLock, Level.ALL);
            Logging.log.addHandler(logFileHandler);
            Logging.debug.addHandler(logFileHandler);
        }
    }
}

