/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.filebot.Logging;
import net.filebot.platform.mac.MacXattrView;

public class MetaAttributeView
extends AbstractMap<String, String> {
    private final Object xattr;

    public MetaAttributeView(File file) throws IOException {
        Path path = file.toPath().toRealPath(new LinkOption[0]);
        this.xattr = Platform.isMac() ? new MacXattrView(path) : Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (this.xattr == null) {
            throw new IOException("UserDefinedFileAttributeView is not supported");
        }
    }

    @Override
    public String get(Object key) {
        return this.get(key.toString());
    }

    public String get(String key) {
        try {
            if (this.xattr instanceof UserDefinedFileAttributeView) {
                UserDefinedFileAttributeView attributeView = (UserDefinedFileAttributeView)this.xattr;
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(attributeView.size(key));
                    attributeView.read(key, buffer);
                    buffer.flip();
                    return StandardCharsets.UTF_8.decode(buffer).toString();
                }
                catch (FileSystemException e) {
                    return null;
                }
            }
            if (this.xattr instanceof MacXattrView) {
                MacXattrView macXattr = (MacXattrView)this.xattr;
                return macXattr.read(key);
            }
        }
        catch (IOException e) {
            Logging.debug.warning(Logging.cause(e));
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        try {
            if (this.xattr instanceof UserDefinedFileAttributeView) {
                UserDefinedFileAttributeView attributeView = (UserDefinedFileAttributeView)this.xattr;
                if (value == null || value.isEmpty()) {
                    attributeView.delete(key);
                } else {
                    attributeView.write(key, StandardCharsets.UTF_8.encode(value));
                }
            }
            if (this.xattr instanceof MacXattrView) {
                MacXattrView macXattr = (MacXattrView)this.xattr;
                if (value == null || value.isEmpty()) {
                    macXattr.delete(key);
                } else {
                    macXattr.write(key, value);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void clear() {
        try {
            for (String key : this.list()) {
                this.put(key, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> list() throws IOException {
        if (this.xattr instanceof UserDefinedFileAttributeView) {
            UserDefinedFileAttributeView attributeView = (UserDefinedFileAttributeView)this.xattr;
            return attributeView.list();
        }
        if (this.xattr instanceof MacXattrView) {
            MacXattrView macXattr = (MacXattrView)this.xattr;
            return macXattr.list();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        try {
            LinkedHashSet<Map.Entry<String, String>> entries = new LinkedHashSet<Map.Entry<String, String>>();
            for (String name : this.list()) {
                entries.add(new AttributeEntry(name));
            }
            return entries;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class AttributeEntry
    implements Map.Entry<String, String> {
        private final String name;

        public AttributeEntry(String name) {
            this.name = name;
        }

        @Override
        public String getKey() {
            return this.name;
        }

        @Override
        public String getValue() {
            return MetaAttributeView.this.get(this.name);
        }

        @Override
        public String setValue(String value) {
            return MetaAttributeView.this.put(this.name, value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

