/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.Resource;
import net.filebot.Settings;
import net.filebot.media.MediaDetection;
import net.filebot.media.XattrMetaInfoProvider;
import net.filebot.similarity.MetricAvg;
import net.filebot.util.FileUtilities;
import net.filebot.util.SystemProperty;
import net.filebot.web.AcoustIDClient;
import net.filebot.web.AnidbClient;
import net.filebot.web.Datasource;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.FanartTVClient;
import net.filebot.web.ID3Lookup;
import net.filebot.web.LocalSearch;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.OMDbClient;
import net.filebot.web.OpenSubtitlesClient;
import net.filebot.web.SearchResult;
import net.filebot.web.ShooterSubtitles;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.SubtitleSearchResult;
import net.filebot.web.TMDbClient;
import net.filebot.web.TMDbTVClient;
import net.filebot.web.TVMazeClient;
import net.filebot.web.TheTVDBClient;
import net.filebot.web.TheTVDBClientV1;
import net.filebot.web.VideoHashSubtitleService;

public final class WebServices {
    public static final OMDbClient OMDb = new OMDbClient();
    public static final TMDbClient TheMovieDB = new TMDbClient(Settings.getApiKey("themoviedb"), SystemProperty.of("net.filebot.WebServices.TheMovieDB.adult", Boolean::parseBoolean, false).get());
    public static final TVMazeClient TVmaze = new TVMazeClient();
    public static final AnidbClient AniDB = new AnidbClientWithLocalSearch(Settings.getApiKey("anidb"), 6);
    public static final TheTVDBClientWithLocalSearch TheTVDB = new TheTVDBClientWithLocalSearch(Settings.getApiKey("thetvdb"));
    public static final TMDbTVClient TheMovieDB_TV = new TMDbTVClient(TheMovieDB);
    public static final TheTVDBClient TheTVDBv2 = new TheTVDBClient(Settings.getApiKey("thetvdb"));
    public static final OpenSubtitlesClient OpenSubtitles = new OpenSubtitlesClientWithLocalSearch(Settings.getApiKey("opensubtitles"), Settings.getApplicationVersion());
    public static final ShooterSubtitles Shooter = new ShooterSubtitles();
    public static final FanartTVClient FanartTV = new FanartTVClient(Settings.getApiKey("fanart.tv"));
    public static final AcoustIDClient AcoustID = new AcoustIDClient(Settings.getApiKey("acoustid"));
    public static final XattrMetaInfoProvider XattrMetaData = new XattrMetaInfoProvider();
    public static final ID3Lookup MediaInfoID3 = new ID3Lookup();
    public static final ExecutorService requestThreadPool = Executors.newCachedThreadPool();
    public static final String LOGIN_SEPARATOR = ":";
    public static final String LOGIN_OPENSUBTITLES = "osdb.user";

    public static Datasource[] getServices() {
        return new Datasource[]{TheMovieDB, OMDb, TheTVDB, AniDB, TheMovieDB_TV, TVmaze, AcoustID, MediaInfoID3, XattrMetaData, OpenSubtitles, Shooter, TheTVDBv2, FanartTV};
    }

    public static MovieIdentificationService[] getMovieIdentificationServices() {
        return new MovieIdentificationService[]{TheMovieDB, OMDb};
    }

    public static EpisodeListProvider[] getEpisodeListProviders() {
        return new EpisodeListProvider[]{TheTVDB, AniDB, TheMovieDB_TV, TVmaze};
    }

    public static MusicIdentificationService[] getMusicIdentificationServices() {
        return new MusicIdentificationService[]{AcoustID, MediaInfoID3};
    }

    public static SubtitleProvider[] getSubtitleProviders(Locale locale) {
        return new SubtitleProvider[]{OpenSubtitles};
    }

    public static VideoHashSubtitleService[] getVideoHashSubtitleServices(Locale locale) {
        switch (locale.getLanguage()) {
            case "zh": {
                return new VideoHashSubtitleService[]{OpenSubtitles, Shooter};
            }
        }
        return new VideoHashSubtitleService[]{OpenSubtitles};
    }

    public static Datasource getService(String name) {
        return WebServices.getService((String)name, (Datasource[])WebServices.getServices());
    }

    public static EpisodeListProvider getEpisodeListProvider(String name) {
        return (EpisodeListProvider)WebServices.getService((String)name, (Datasource[])WebServices.getEpisodeListProviders());
    }

    public static MovieIdentificationService getMovieIdentificationService(String name) {
        return (MovieIdentificationService)WebServices.getService((String)name, (Datasource[])WebServices.getMovieIdentificationServices());
    }

    public static MusicIdentificationService getMusicIdentificationService(String name) {
        return (MusicIdentificationService)WebServices.getService((String)name, (Datasource[])WebServices.getMusicIdentificationServices());
    }

    public static <T extends Datasource> T getService(String name, T ... services) {
        return (T)((Datasource)Arrays.stream(services).filter(it -> it.getIdentifier().equalsIgnoreCase(name)).findFirst().orElse(null));
    }

    private WebServices() {
        throw new UnsupportedOperationException();
    }

    public static String[] getLogin(String key) {
        try {
            String[] values = Settings.forPackage(WebServices.class).get(key, LOGIN_SEPARATOR).split(LOGIN_SEPARATOR, 2);
            if (values != null && values.length == 2 && values[0] != null && values[1] != null) {
                return values;
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, e.getMessage(), e);
        }
        return new String[]{"", ""};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setLogin(String id, String user, String password) {
        if ((user == null || user.isEmpty()) && (password == null || password.isEmpty())) {
            if (!LOGIN_OPENSUBTITLES.equals(id)) throw new IllegalArgumentException();
            OpenSubtitles.setUser("", "");
            Settings.forPackage(WebServices.class).remove(id);
            return;
        } else {
            if (user == null || password == null || user.contains(LOGIN_SEPARATOR) || user.isEmpty() && !password.isEmpty() || !user.isEmpty() && password.isEmpty()) {
                throw new IllegalArgumentException(String.format("Illegal login: %s:%s", user, password));
            }
            if (!LOGIN_OPENSUBTITLES.equals(id)) throw new IllegalArgumentException();
            String password_md5 = FileUtilities.md5(password);
            OpenSubtitles.setUser(user, password_md5);
            Settings.forPackage(WebServices.class).put(id, user + LOGIN_SEPARATOR + password_md5);
        }
    }

    static {
        String[] osdbLogin = WebServices.getLogin(LOGIN_OPENSUBTITLES);
        OpenSubtitles.setUser(osdbLogin[0], osdbLogin[1]);
    }

    public static class OpenSubtitlesClientWithLocalSearch
    extends OpenSubtitlesClient {
        private final Resource<LocalSearch<SubtitleSearchResult>> localIndex = Resource.lazy(() -> new LocalSearch<SubtitleSearchResult>(MediaDetection.releaseInfo.getOpenSubtitlesIndex(), SearchResult::getEffectiveNames));

        public OpenSubtitlesClientWithLocalSearch(String name, String version) {
            super(name, version);
        }

        @Override
        public List<SubtitleSearchResult> search(String query) throws Exception {
            return MediaDetection.sortBySimilarity(this.localIndex.get().search(query), Collections.singleton(query), new MetricAvg(MediaDetection.getSeriesMatchMetric(), MediaDetection.getMovieMatchMetric()));
        }
    }

    public static class AnidbClientWithLocalSearch
    extends AnidbClient {
        public AnidbClientWithLocalSearch(String client, int clientver) {
            super(client, clientver);
        }

        @Override
        public SearchResult[] getAnimeTitles() throws Exception {
            return MediaDetection.releaseInfo.getAnidbIndex();
        }
    }

    public static class TheTVDBClientWithLocalSearch
    extends TheTVDBClientV1 {
        private final Resource<LocalSearch<SearchResult>> localIndex = Resource.lazy(() -> new LocalSearch<SearchResult>(MediaDetection.releaseInfo.getTheTVDBIndex(), SearchResult::getEffectiveNames));

        public TheTVDBClientWithLocalSearch(String apikey) {
            super(apikey);
        }

        private SearchResult merge(SearchResult prime, List<SearchResult> group) {
            int id = prime.getId();
            String name = prime.getName();
            String[] aliasNames = (String[])group.stream().flatMap(it -> Arrays.stream(it.getAliasNames())).filter(n -> !n.equals(name)).distinct().toArray(String[]::new);
            return new SearchResult(id, name, aliasNames);
        }

        @Override
        public List<SearchResult> fetchSearchResult(String query, Locale locale) throws Exception {
            Future<List> apiSearch = requestThreadPool.submit(() -> TheTVDBClientWithLocalSearch.super.fetchSearchResult(query, locale));
            Future<List> localSearch = requestThreadPool.submit(() -> this.localIndex.get().search(query));
            Map results = Stream.of(apiSearch.get(), localSearch.get()).flatMap(Collection::stream).collect(Collectors.groupingBy(SearchResult::getId, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), group -> this.merge((SearchResult)group.get(0), (List<SearchResult>)group))));
            return MediaDetection.sortBySimilarity(results.values(), Collections.singleton(query), MediaDetection.getSeriesMatchMetric());
        }
    }
}

