/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import net.sf.sevenzipjbinding.IArchiveOpenCallback;
import net.sf.sevenzipjbinding.IArchiveOpenVolumeCallback;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;

class ArchiveOpenVolumeCallback
implements IArchiveOpenVolumeCallback,
IArchiveOpenCallback,
Closeable {
    private Map<String, RandomAccessFile> openedRandomAccessFileList = new HashMap<String, RandomAccessFile>();
    private String name;

    ArchiveOpenVolumeCallback() {
    }

    @Override
    public Object getProperty(PropID propID) throws SevenZipException {
        switch (propID) {
            case NAME: {
                return this.name;
            }
        }
        return null;
    }

    @Override
    public IInStream getStream(String filename) throws SevenZipException {
        try {
            RandomAccessFile randomAccessFile = this.openedRandomAccessFileList.get(filename);
            if (randomAccessFile != null) {
                randomAccessFile.seek(0L);
                this.name = filename;
                return new RandomAccessFileInStream(randomAccessFile);
            }
            randomAccessFile = new RandomAccessFile(filename, "r");
            this.openedRandomAccessFileList.put(filename, randomAccessFile);
            this.name = filename;
            return new RandomAccessFileInStream(randomAccessFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        for (RandomAccessFile file : this.openedRandomAccessFileList.values()) {
            file.close();
        }
    }

    @Override
    public void setCompleted(Long files, Long bytes) throws SevenZipException {
    }

    @Override
    public void setTotal(Long files, Long bytes) throws SevenZipException {
    }
}

