/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.MapOptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class BindingsHandler
extends MapOptionHandler {
    public BindingsHandler(CmdLineParser parser, OptionDef option, Setter<? super Map<?, ?>> setter) {
        super(parser, option, setter);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "[name=value]";
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        int pos;
        FieldSetter fs = this.setter.asFieldSetter();
        Map map = (Map)fs.getValue();
        if (map == null) {
            map = this.createNewCollection(fs.getType());
            fs.addValue(map);
        }
        for (pos = 0; pos < params.size(); ++pos) {
            if (params.getParameter(pos).startsWith("-")) {
                return pos;
            }
            String[] nv = RegularExpressions.EQUALS.split(params.getParameter(pos), 2);
            if (nv.length < 2) {
                return pos;
            }
            String n = this.getName(nv[0]);
            String v = this.getValue(nv[1]);
            this.addToMap(map, n, v);
        }
        return pos;
    }

    public String getName(String n) throws CmdLineException {
        if (!this.isIdentifier(n)) {
            throw new CmdLineException(this.owner, "\"" + n + "\" is not a valid identifier", null);
        }
        return n;
    }

    public String getValue(String v) throws CmdLineException {
        if (v.startsWith("@")) {
            File f = new File(v.substring(1));
            try {
                return FileUtilities.readTextFile(f).trim();
            }
            catch (IOException e) {
                throw new CmdLineException(this.owner, "Failed to read @file", e);
            }
        }
        return v;
    }

    public boolean isIdentifier(String n) {
        int c;
        if (n == null || n.isEmpty()) {
            return false;
        }
        for (int i = 0; i < n.length(); i += Character.charCount(c)) {
            c = n.codePointAt(i);
            if (!(i == 0 ? !Character.isUnicodeIdentifierStart(c) : !Character.isUnicodeIdentifierPart(c))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Map createNewCollection(Class<? extends Map> type) {
        return new LinkedHashMap();
    }
}

