/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.filebot.HistorySpooler;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.RenameAction;
import net.filebot.Settings;
import net.filebot.StandardRenameAction;
import net.filebot.WebServices;
import net.filebot.archive.Archive;
import net.filebot.archive.FileMapper;
import net.filebot.cli.CmdlineException;
import net.filebot.cli.CmdlineInterface;
import net.filebot.cli.ConflictAction;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.ExpressionFilter;
import net.filebot.format.ExpressionFormat;
import net.filebot.format.MediaBindingBean;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationFileReader;
import net.filebot.hash.VerificationFileWriter;
import net.filebot.hash.VerificationUtilities;
import net.filebot.media.AutoDetection;
import net.filebot.media.MediaDetection;
import net.filebot.media.VideoQuality;
import net.filebot.media.XattrMetaInfo;
import net.filebot.media.XattrMetaInfoProvider;
import net.filebot.similarity.CommonSequenceMatcher;
import net.filebot.similarity.EpisodeMatcher;
import net.filebot.similarity.Match;
import net.filebot.subtitle.SubtitleFormat;
import net.filebot.subtitle.SubtitleNaming;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.util.EntryList;
import net.filebot.util.FileUtilities;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.MemoryFile;
import net.filebot.vfs.SimpleFileInfo;
import net.filebot.web.AudioTrack;
import net.filebot.web.Datasource;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.Movie;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MoviePart;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.OpenSubtitlesClient;
import net.filebot.web.SearchResult;
import net.filebot.web.SortOrder;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.VideoHashSubtitleService;

public class CmdlineOperations
implements CmdlineInterface {
    @Override
    public List<File> rename(Collection<File> files, RenameAction action, ConflictAction conflict, File output, ExpressionFileFormat format, Datasource db, String query, SortOrder order, ExpressionFilter filter, Locale locale, boolean strict) throws Exception {
        if (db instanceof MovieIdentificationService) {
            return this.renameMovie(files, action, conflict, output, format, (MovieIdentificationService)db, query, filter, locale, strict);
        }
        if (db instanceof EpisodeListProvider) {
            return this.renameSeries(files, action, conflict, output, format, (EpisodeListProvider)db, query, order, filter, locale, strict);
        }
        if (db instanceof MusicIdentificationService) {
            return this.renameMusic(files, action, conflict, output, format, (MusicIdentificationService)db);
        }
        if (db instanceof XattrMetaInfoProvider) {
            return this.renameFiles(files, action, conflict, output, format, (XattrMetaInfoProvider)db, filter, strict);
        }
        AutoDetection auto = new AutoDetection(files, false, locale);
        ArrayList<File> results = new ArrayList<File>();
        for (Map.Entry<AutoDetection.Group, Set<File>> it : auto.group().entrySet()) {
            if (it.getKey().types().length == 1) {
                block7: for (AutoDetection.Type key : it.getKey().types()) {
                    switch (key) {
                        case Movie: {
                            results.addAll(this.renameMovie((Collection<File>)it.getValue(), action, conflict, output, format, WebServices.TheMovieDB, query, filter, locale, strict));
                            continue block7;
                        }
                        case Series: {
                            results.addAll(this.renameSeries((Collection<File>)it.getValue(), action, conflict, output, format, WebServices.TheTVDB, query, order, filter, locale, strict));
                            continue block7;
                        }
                        case Anime: {
                            results.addAll(this.renameSeries((Collection<File>)it.getValue(), action, conflict, output, format, WebServices.AniDB, query, order, filter, locale, strict));
                            continue block7;
                        }
                        case Music: {
                            results.addAll(this.renameMusic((Collection<File>)it.getValue(), action, conflict, output, format, WebServices.MediaInfoID3, WebServices.AcoustID));
                        }
                    }
                }
                continue;
            }
            Logging.debug.warning(Logging.format("Failed to process group: %s => %s", it.getKey(), it.getValue()));
        }
        if (results.isEmpty()) {
            throw new CmdlineException("Failed to identify or process any files");
        }
        return results;
    }

    @Override
    public List<File> rename(EpisodeListProvider db, String query, ExpressionFileFormat format, ExpressionFilter filter, SortOrder order, Locale locale, boolean strict, List<File> files, RenameAction action, ConflictAction conflict, File outputDir) throws Exception {
        List<Episode> episodes = this.fetchEpisodeList(db, query, filter, order, locale, strict);
        ArrayList matches = new ArrayList();
        for (int i = 0; i < files.size() && i < episodes.size(); ++i) {
            matches.add(new Match<File, Episode>(files.get(i), episodes.get(i)));
        }
        return this.renameAll(this.formatMatches(matches, format, outputDir), action, conflict, matches);
    }

    @Override
    public List<File> rename(Map<File, File> renameMap, RenameAction renameAction, ConflictAction conflict) throws Exception {
        return this.renameAll(renameMap, renameAction, conflict, null);
    }

    /*
     * WARNING - void declaration
     */
    public List<File> renameSeries(Collection<File> files, RenameAction renameAction, ConflictAction conflictAction, File outputDir, ExpressionFileFormat format, EpisodeListProvider db, String query, SortOrder sortOrder, ExpressionFilter filter, Locale locale, boolean strict) throws Exception {
        Logging.log.config(Logging.format("Rename episodes using [%s]", db.getName()));
        List<File> fileset = FileUtilities.sortByUniquePath(FileUtilities.filter(files, FileUtilities.not(MediaDetection.getClutterFileFilter())));
        List<File> mediaFiles = FileUtilities.filter(fileset, MediaTypes.VIDEO_FILES, MediaTypes.SUBTITLE_FILES);
        if (mediaFiles.isEmpty()) {
            throw new CmdlineException("No media files: " + files);
        }
        ArrayList matches = new ArrayList();
        for (Map.Entry<Set<File>, Set<String>> sameSeriesGroup : MediaDetection.mapSeriesNamesByFiles(mediaFiles, locale, db == WebServices.AniDB).entrySet()) {
            ArrayList<List<Object>> batchSets = new ArrayList<List<Object>>();
            if (sameSeriesGroup.getValue() != null && sameSeriesGroup.getValue().size() > 0) {
                batchSets.add(new ArrayList(sameSeriesGroup.getKey()));
            } else {
                batchSets.addAll(FileUtilities.mapByFolder((Iterable<File>)sameSeriesGroup.getKey()).values());
            }
            for (List list : batchSets) {
                void var20_25;
                if (query == null) {
                    List<String> seriesNames = MediaDetection.detectSeriesNames((Collection<File>)list, db == WebServices.AniDB, locale);
                    Logging.log.config("Auto-detected query: " + seriesNames);
                    if (seriesNames.size() == 0) {
                        Logging.log.warning("Failed to detect query for files: " + list);
                        continue;
                    }
                    if (strict && seriesNames.size() > 1) {
                        throw new CmdlineException("Multiple queries: Processing multiple shows at once requires -non-strict matching: " + seriesNames);
                    }
                    List<Episode> list2 = this.fetchEpisodeSet(db, seriesNames, sortOrder, locale, strict, 5);
                } else {
                    List<Episode> list3 = this.fetchEpisodeSet(db, Collections.singleton(query), sortOrder, locale, false, 1);
                }
                if (var20_25.isEmpty()) continue;
                List<Episode> list4 = this.applyExpressionFilter((List)var20_25, filter);
                for (List<File> filesPerType : MediaDetection.mapByMediaExtension(FileUtilities.filter(list, MediaTypes.VIDEO_FILES, MediaTypes.SUBTITLE_FILES)).values()) {
                    matches.addAll(this.matchEpisodes(filesPerType, list4, strict));
                }
            }
        }
        if (matches.isEmpty()) {
            throw new CmdlineException("Failed to match files to episode data");
        }
        ArrayList<Match<File, Episode>> derivateMatches = new ArrayList<Match<File, Episode>>();
        TreeSet<File> derivateFiles = new TreeSet<File>(fileset);
        derivateFiles.removeAll(mediaFiles);
        block3: for (File file : derivateFiles) {
            for (Match match : matches) {
                if (!file.getPath().startsWith(((File)match.getValue()).getParentFile().getPath()) || !FileUtilities.isDerived(file, (File)match.getValue()) || !(match.getCandidate() instanceof Episode)) continue;
                derivateMatches.add(new Match<File, Episode>(file, ((Episode)match.getCandidate()).clone()));
                continue block3;
            }
        }
        matches.addAll(derivateMatches);
        return this.renameAll(this.formatMatches(matches, format, outputDir), renameAction, conflictAction, matches);
    }

    private List<Match<File, Object>> matchEpisodes(Collection<File> files, Collection<Episode> episodes, boolean strict) throws Exception {
        EpisodeMatcher matcher = new EpisodeMatcher(files, episodes, strict);
        List<Match<File, Object>> matches = matcher.match();
        for (File failedMatch : matcher.remainingValues()) {
            Logging.log.warning("No matching episode: " + failedMatch.getName());
        }
        if (!strict) {
            return matches;
        }
        ArrayList<Match<File, Object>> validMatches = new ArrayList<Match<File, Object>>();
        for (Match<File, Object> it : matches) {
            if (!MediaDetection.isEpisodeNumberMatch(it.getValue(), (Episode)it.getCandidate())) continue;
            validMatches.add(it);
        }
        return validMatches;
    }

    private List<Episode> fetchEpisodeSet(EpisodeListProvider db, Collection<String> names, SortOrder sortOrder, Locale locale, boolean strict, int limit) throws Exception {
        LinkedHashSet<SearchResult> shows = new LinkedHashSet<SearchResult>();
        LinkedHashSet<Episode> episodes = new LinkedHashSet<Episode>();
        for (String query : names) {
            List<SearchResult> selectedSearchResults;
            List<SearchResult> results = db.search(query, locale);
            if (results.size() <= 0 || (selectedSearchResults = this.selectSearchResult(query, results, true, true, strict, limit)) == null) continue;
            for (SearchResult it : selectedSearchResults) {
                if (!shows.add(it)) continue;
                try {
                    Logging.log.fine(Logging.format("Fetching episode data for [%s]", it.getName()));
                    episodes.addAll(db.getEpisodeList(it, sortOrder, locale));
                }
                catch (IOException e) {
                    throw new CmdlineException(String.format("Failed to fetch episode data for [%s]: %s", it, e.getMessage()), e);
                }
            }
        }
        if (episodes.isEmpty()) {
            Logging.log.warning("Failed to fetch episode data: " + names);
        }
        return new ArrayList<Episode>(episodes);
    }

    public List<File> renameMovie(Collection<File> files, RenameAction renameAction, ConflictAction conflictAction, File outputDir, ExpressionFileFormat format, MovieIdentificationService service, String query, ExpressionFilter filter, Locale locale, boolean strict) throws Exception {
        Logging.log.config(Logging.format("Rename movies using [%s]", service.getName()));
        List<File> fileset = FileUtilities.sortByUniquePath(FileUtilities.filter(files, FileUtilities.not(MediaDetection.getClutterFileFilter())));
        TreeSet<File> movieFiles = new TreeSet<File>(FileUtilities.filter(fileset, MediaTypes.VIDEO_FILES));
        TreeSet<File> nfoFiles = new TreeSet<File>(FileUtilities.filter(fileset, MediaTypes.NFO_FILES));
        ArrayList<File> orphanedFiles = new ArrayList<File>(FileUtilities.filter(fileset, FileUtilities.FILES));
        orphanedFiles.removeAll(movieFiles);
        orphanedFiles.removeAll(nfoFiles);
        HashMap derivatesByMovieFile = new HashMap();
        for (File movieFile : movieFiles) {
            derivatesByMovieFile.put(movieFile, new ArrayList());
        }
        block5: for (File file : orphanedFiles) {
            Iterator<File> orphanParent = FileUtilities.listPath(file);
            for (File movieFile : movieFiles) {
                if (!orphanParent.contains(movieFile.getParentFile()) || !FileUtilities.isDerived(file, movieFile)) continue;
                ((List)derivatesByMovieFile.get(movieFile)).add(file);
                continue block5;
            }
        }
        for (List derivates : derivatesByMovieFile.values()) {
            orphanedFiles.removeAll(derivates);
        }
        TreeMap<File, Movie> movieByFile = new TreeMap<File, Movie>();
        if (query == null) {
            TreeSet<File> effectiveNfoFileSet = new TreeSet<File>((Collection<File>)nfoFiles);
            for (File dir : FileUtilities.mapByFolder(movieFiles).keySet()) {
                effectiveNfoFileSet.addAll(FileUtilities.getChildren(dir, MediaTypes.NFO_FILES));
            }
            for (File dir : FileUtilities.filter(fileset, FileUtilities.FOLDERS)) {
                effectiveNfoFileSet.addAll(FileUtilities.getChildren(dir, MediaTypes.NFO_FILES));
            }
            for (File nfo : effectiveNfoFileSet) {
                try {
                    Movie movie2 = MediaDetection.grepMovie(nfo, service, locale);
                    if (movie2 == null) continue;
                    if (nfoFiles.contains(nfo)) {
                        movieByFile.put(nfo, movie2);
                    }
                    if (MediaDetection.isDiskFolder(nfo.getParentFile())) {
                        for (File folder : fileset) {
                            if (!nfo.getParentFile().equals(folder)) continue;
                            movieByFile.put(folder, movie2);
                        }
                        continue;
                    }
                    TreeSet<File> siblingMovieFiles = new TreeSet<File>(FileUtilities.filter(movieFiles, new FileUtilities.ParentFilter(nfo.getParentFile())));
                    String baseName = MediaDetection.stripReleaseInfo(FileUtilities.getName(nfo)).toLowerCase();
                    for (File movieFile : siblingMovieFiles) {
                        if (baseName.isEmpty() || !MediaDetection.stripReleaseInfo(FileUtilities.getName(movieFile)).toLowerCase().startsWith(baseName)) continue;
                        movieByFile.put(movieFile, movie2);
                    }
                }
                catch (Exception e) {
                    Logging.log.log(Level.WARNING, "Failed to grep IMDbID: " + nfo.getName(), e);
                }
            }
        } else {
            Logging.log.fine(Logging.format("Looking up movie by query [%s]", query));
            List<Movie> results = service.searchMovie(query, locale);
            List<Movie> options = this.applyExpressionFilter(results, filter);
            if (options.isEmpty()) {
                throw new CmdlineException("Failed to find a valid match: " + results);
            }
            Movie movie3 = this.selectSearchResult(query, options);
            for (File file : files) {
                movieByFile.put(file, movie3);
            }
        }
        ArrayList<File> movieMatchFiles = new ArrayList<File>();
        movieMatchFiles.addAll(movieFiles);
        movieMatchFiles.addAll(nfoFiles);
        movieMatchFiles.addAll(FileUtilities.filter(files, FileUtilities.FOLDERS));
        movieMatchFiles.addAll(FileUtilities.filter(orphanedFiles, MediaTypes.SUBTITLE_FILES));
        if (fileset.isEmpty() || movieMatchFiles.isEmpty()) {
            throw new CmdlineException("No media files: " + files);
        }
        HashMap<Movie, SortedSet> filesByMovie = new HashMap<Movie, SortedSet>();
        for (File file : movieMatchFiles) {
            Movie movie4 = (Movie)movieByFile.get(file);
            if (movie4 == null) {
                Logging.log.fine(Logging.format("Auto-detect movie from context: [%s]", file));
                List<Movie> options = MediaDetection.detectMovie(file, service, locale, strict);
                options = this.applyExpressionFilter(options, filter);
                List<Movie> perfectMatches = MediaDetection.matchMovieByWordSequence(FileUtilities.getName(file), options, 0);
                if (perfectMatches.size() > 0) {
                    options = perfectMatches;
                }
                try {
                    if (options.size() > 0) {
                        movie4 = this.selectSearchResult(MediaDetection.stripReleaseInfo(FileUtilities.getName(file)), options);
                        movie4 = MediaDetection.getLocalizedMovie(service, movie4, locale);
                    }
                }
                catch (Exception e) {
                    Logging.log.warning(Logging.cause(e));
                }
            }
            if (movie4 == null) continue;
            TreeSet<File> movieParts = (TreeSet<File>)filesByMovie.get(movie4);
            if (movieParts == null) {
                movieParts = new TreeSet<File>();
                filesByMovie.put(movie4, movieParts);
            }
            movieParts.add(file);
        }
        ArrayList matches = new ArrayList();
        filesByMovie.forEach((movie, fs) -> MediaDetection.groupByMediaCharacteristics(fs).forEach(moviePartFiles -> {
            for (int i = 0; i < moviePartFiles.size(); ++i) {
                Movie moviePart = moviePartFiles.size() == 1 ? movie : new MoviePart((Movie)movie, i + 1, moviePartFiles.size());
                matches.add(new Match(moviePartFiles.get(i), moviePart.clone()));
                List derivates = (List)derivatesByMovieFile.get(moviePartFiles.get(i));
                if (derivates == null) continue;
                for (File derivate : derivates) {
                    matches.add(new Match<File, Movie>(derivate, moviePart.clone()));
                }
            }
        }));
        return this.renameAll(this.formatMatches(matches, format, outputDir), renameAction, conflictAction, matches);
    }

    public List<File> renameMusic(Collection<File> files, RenameAction renameAction, ConflictAction conflictAction, File outputDir, ExpressionFileFormat format, MusicIdentificationService ... services) throws Exception {
        List<File> audioFiles = FileUtilities.sortByUniquePath(FileUtilities.filter(files, MediaTypes.AUDIO_FILES, MediaTypes.VIDEO_FILES));
        ArrayList matches = new ArrayList();
        LinkedHashSet<File> remaining = new LinkedHashSet<File>(audioFiles);
        for (int i = 0; i < services.length && remaining.size() > 0; ++i) {
            Logging.log.config(Logging.format("Rename music using %s", services[i].getIdentifier()));
            services[i].lookup(remaining).forEach((file, music) -> {
                if (music != null) {
                    matches.add(new Match<File, AudioTrack>((File)file, music.clone()));
                    remaining.remove(file);
                }
            });
        }
        remaining.forEach(f -> Logging.log.warning(Logging.format("Failed to process music file: %s", f)));
        return this.renameAll(this.formatMatches(matches, format, outputDir), renameAction, conflictAction, null);
    }

    public List<File> renameFiles(Collection<File> files, RenameAction renameAction, ConflictAction conflictAction, File outputDir, ExpressionFileFormat format, XattrMetaInfoProvider service, ExpressionFilter filter, boolean strict) throws Exception {
        Logging.log.config(Logging.format("Rename files using [%s]", service.getName()));
        LinkedHashMap<File, File> renameMap = new LinkedHashMap<File, File>();
        Map<File, Object> matches = service.match(files, strict);
        service.match(files, strict).forEach((k, v) -> {
            MediaBindingBean bindingBean = new MediaBindingBean(v, (File)k, matches);
            if (filter == null || filter.matches(bindingBean)) {
                String destinationPath = format != null ? format.format(bindingBean) : (v instanceof File ? v.toString() : FileUtilities.validateFileName(v.toString()));
                renameMap.put((File)k, this.getDestinationFile((File)k, destinationPath, outputDir));
            }
        });
        return this.renameAll(renameMap, renameAction, conflictAction, null);
    }

    private Map<File, Object> getContext(final List<Match<File, ?>> matches) {
        return new AbstractMap<File, Object>(){

            @Override
            public Set<Map.Entry<File, Object>> entrySet() {
                return matches.stream().collect(Collectors.toMap(it -> (File)it.getValue(), it -> it.getCandidate())).entrySet();
            }
        };
    }

    private File getDestinationFile(File original, String newName, File outputDir) {
        String extension = FileUtilities.getExtension(original);
        File newFile = new File(extension != null ? newName + '.' + extension.toLowerCase() : newName);
        if (outputDir != null && !newFile.isAbsolute()) {
            newFile = new File(outputDir, newFile.getPath());
        }
        if (FileUtilities.isInvalidFilePath(newFile) && !Settings.isUnixFS()) {
            Logging.log.config("Stripping invalid characters from new path: " + newName);
            newFile = FileUtilities.validateFilePath(newFile);
        }
        return newFile;
    }

    private Map<File, File> formatMatches(List<Match<File, ?>> matches, ExpressionFileFormat format, File outputDir) throws Exception {
        LinkedHashMap<File, File> renameMap = new LinkedHashMap<File, File>();
        for (Match<File, ?> match : matches) {
            File file = match.getValue();
            Object object = match.getCandidate();
            String destinationPath = format != null ? format.format(new MediaBindingBean(object, file, this.getContext(matches))) : FileUtilities.validateFileName(object.toString());
            renameMap.put(file, this.getDestinationFile(file, destinationPath, outputDir));
        }
        return renameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> renameAll(Map<File, File> renameMap, RenameAction renameAction, ConflictAction conflictAction, List<Match<File, ?>> matches) throws Exception {
        File source;
        if (renameMap.isEmpty()) {
            throw new CmdlineException("Failed to identify or process any files");
        }
        LinkedHashMap<File, File> renameLog = new LinkedHashMap<File, File>();
        try {
            for (Map.Entry<File, File> entry : renameMap.entrySet()) {
                try {
                    source = entry.getKey();
                    File destination = entry.getValue();
                    if (!destination.isAbsolute()) {
                        destination = FileUtilities.resolve(source, destination);
                    }
                    if (!destination.equals(source) && destination.exists()) {
                        if (conflictAction == ConflictAction.FAIL) {
                            throw new CmdlineException("File already exists: " + destination);
                        }
                        if (conflictAction == ConflictAction.OVERRIDE || conflictAction == ConflictAction.AUTO && VideoQuality.isBetter(source, destination)) {
                            if (renameAction.canRevert()) {
                                try {
                                    Logging.log.fine(Logging.format("[%s] Delete [%s]", new Object[]{conflictAction, destination}));
                                    FileUtilities.delete(destination);
                                }
                                catch (Exception e) {
                                    Logging.log.warning(Logging.format("[%s] Failed to delete [%s]: %s", new Object[]{conflictAction, destination, e}));
                                }
                            }
                        } else if (conflictAction == ConflictAction.INDEX) {
                            destination = CmdlineOperations.nextAvailableIndexedName(destination);
                        }
                    }
                    if (!destination.equals(source) && !destination.exists()) {
                        Logging.log.info(Logging.format("[%s] From [%s] to [%s]", renameAction, source, destination));
                        destination = renameAction.rename(source, destination);
                        renameLog.put(source, destination);
                        continue;
                    }
                    Logging.log.info(Logging.format("Skipped [%s] because [%s] already exists", source, destination));
                }
                catch (IOException e) {
                    Logging.log.warning(Logging.format("[%s] Failure: %s", renameAction, e));
                    throw e;
                }
            }
            if (renameAction.canRevert()) {
                HistorySpooler.getInstance().append(renameLog.entrySet());
            }
        }
        catch (Throwable throwable) {
            if (renameAction.canRevert()) {
                HistorySpooler.getInstance().append(renameLog.entrySet());
            }
            Logging.log.fine(Logging.format("Processed %d files", renameLog.size()));
            throw throwable;
        }
        Logging.log.fine(Logging.format("Processed %d files", renameLog.size()));
        if (matches != null && renameLog.size() > 0 && renameAction.canRevert()) {
            for (Match match : matches) {
                File destination;
                source = (File)match.getValue();
                Object infoObject = match.getCandidate();
                if (infoObject == null || (destination = (File)renameLog.get(source)) == null || !destination.isFile()) continue;
                XattrMetaInfo.xattr.setMetaInfo(destination, infoObject, source.getName());
            }
        }
        return new ArrayList<File>(renameLog.values());
    }

    protected static File nextAvailableIndexedName(File file) {
        File parent = file.getParentFile();
        String name = FileUtilities.getName(file);
        String ext = FileUtilities.getExtension(file);
        return IntStream.range(1, 100).mapToObj(i -> new File(parent, name + '.' + i + '.' + ext)).filter(f -> !f.exists()).findFirst().get();
    }

    @Override
    public List<File> getSubtitles(Collection<File> files, String query, Language language, SubtitleFormat output, Charset encoding, SubtitleNaming format, boolean strict) throws Exception {
        Map<File, File> downloads;
        Map<File, List<SubtitleDescriptor>> options;
        files = FileUtilities.filter(files, MediaTypes.VIDEO_FILES);
        files = FileUtilities.sortByUniquePath(FileUtilities.filter(files, FileUtilities.not(MediaDetection.getClutterFileFilter())));
        ArrayList<File> remainingVideos = new ArrayList<File>(files);
        ArrayList<File> subtitleFiles = new ArrayList<File>();
        Logging.log.finest(Logging.format("Get [%s] subtitles for %d files", language.getName(), remainingVideos.size()));
        if (remainingVideos.isEmpty()) {
            throw new CmdlineException("No video files: " + files);
        }
        for (VideoHashSubtitleService videoHashSubtitleService : WebServices.getVideoHashSubtitleServices(language.getLocale())) {
            if (remainingVideos.isEmpty() || !CmdlineOperations.requireLogin(videoHashSubtitleService)) continue;
            try {
                Logging.log.fine("Looking up subtitles by hash via " + videoHashSubtitleService.getName());
                options = SubtitleUtilities.lookupSubtitlesByHash(videoHashSubtitleService, remainingVideos, language.getLocale(), false, strict);
                downloads = this.downloadSubtitleBatch(videoHashSubtitleService, options, output, encoding, format);
                remainingVideos.removeAll(downloads.keySet());
                subtitleFiles.addAll(downloads.values());
            }
            catch (Exception e) {
                Logging.log.warning("Lookup by hash failed: " + e.getMessage());
            }
        }
        for (Datasource datasource : WebServices.getSubtitleProviders(language.getLocale())) {
            if (strict || remainingVideos.isEmpty() || !CmdlineOperations.requireLogin(datasource)) continue;
            try {
                Logging.log.fine(Logging.format("Looking up subtitles by name via %s", datasource.getName()));
                options = SubtitleUtilities.findSubtitlesByName((SubtitleProvider)datasource, remainingVideos, language.getLocale(), query, false, strict);
                downloads = this.downloadSubtitleBatch(datasource, options, output, encoding, format);
                remainingVideos.removeAll(downloads.keySet());
                subtitleFiles.addAll(downloads.values());
            }
            catch (Exception e) {
                Logging.log.warning(Logging.format("Search by name failed: %s", e.getMessage()));
            }
        }
        for (File it : remainingVideos) {
            Logging.log.warning("No matching subtitles found: " + it);
        }
        return subtitleFiles;
    }

    protected static boolean requireLogin(Object service) {
        OpenSubtitlesClient osdb;
        if (service instanceof OpenSubtitlesClient && (osdb = (OpenSubtitlesClient)service).isAnonymous()) {
            throw new CmdlineException(String.format("%s: Please enter your login details by calling `filebot -script fn:configure`", osdb.getName()));
        }
        return true;
    }

    @Override
    public List<File> getMissingSubtitles(Collection<File> files, String query, final Language language, SubtitleFormat output, Charset encoding, final SubtitleNaming format, boolean strict) throws Exception {
        List<File> videoFiles = FileUtilities.filter(FileUtilities.filter(files, MediaTypes.VIDEO_FILES), new FileFilter(){
            private Map<File, List<File>> cache = new HashMap<File, List<File>>();

            public boolean matchesLanguageCode(File f) {
                Language languageSuffix = Language.getLanguage(MediaDetection.releaseInfo.getSubtitleLanguageTag(FileUtilities.getName(f)));
                if (languageSuffix != null) {
                    return languageSuffix.getCode().equals(language.getCode());
                }
                return false;
            }

            @Override
            public boolean accept(File video) {
                if (!video.isFile()) {
                    return false;
                }
                List subtitleFiles = this.cache.computeIfAbsent(video.getParentFile(), parent -> FileUtilities.getChildren(parent, MediaTypes.SUBTITLE_FILES));
                if (format == SubtitleNaming.ORIGINAL) {
                    return subtitleFiles.size() == 0;
                }
                return subtitleFiles.stream().allMatch(f -> {
                    if (FileUtilities.isDerived(f, video)) {
                        return format != SubtitleNaming.MATCH_VIDEO && !this.matchesLanguageCode((File)f);
                    }
                    return true;
                });
            }
        });
        if (videoFiles.isEmpty()) {
            Logging.log.info("No missing subtitles");
            return Collections.emptyList();
        }
        return this.getSubtitles(videoFiles, query, language, output, encoding, format, strict);
    }

    private Map<File, File> downloadSubtitleBatch(Datasource service, Map<File, List<SubtitleDescriptor>> subtitles, SubtitleFormat outputFormat, Charset outputEncoding, SubtitleNaming naming) {
        LinkedHashMap<File, File> downloads = new LinkedHashMap<File, File>();
        subtitles.forEach((movie, options) -> {
            if (options.size() > 0) {
                SubtitleDescriptor subtitle = (SubtitleDescriptor)options.get(0);
                try {
                    downloads.put((File)movie, this.downloadSubtitle(service, subtitle, (File)movie, outputFormat, outputEncoding, naming));
                }
                catch (Exception e) {
                    Logging.log.warning(Logging.format("Failed to download %s: %s", subtitle, e));
                }
            }
        });
        return downloads;
    }

    private File downloadSubtitle(Datasource service, SubtitleDescriptor descriptor, File movieFile, SubtitleFormat outputFormat, Charset outputEncoding, SubtitleNaming naming) throws Exception {
        Logging.log.config(Logging.format("Fetching [%s] subtitles [%s] from [%s]", descriptor.getLanguageName(), descriptor.getPath(), service.getName()));
        MemoryFile subtitleFile = SubtitleUtilities.fetchSubtitle(descriptor);
        String extension = FileUtilities.getExtension(subtitleFile.getName());
        ByteBuffer data = subtitleFile.getData();
        if (outputFormat != null || outputEncoding != null) {
            if (outputFormat != null) {
                extension = outputFormat.getFilter().extension();
            }
            if (outputEncoding == null) {
                outputEncoding = StandardCharsets.UTF_8;
            }
            Logging.log.finest(Logging.format("Export [%s] as [%s / %s]", new Object[]{subtitleFile.getName(), outputFormat, outputEncoding}));
            data = SubtitleUtilities.exportSubtitles(subtitleFile, outputFormat, 0L, outputEncoding);
        }
        File destination = new File(movieFile.getParentFile(), naming.format(movieFile, descriptor, extension));
        Logging.log.info(Logging.format("Writing [%s] to [%s]", subtitleFile.getName(), destination.getName()));
        FileUtilities.writeFile(data, destination);
        return destination;
    }

    protected <T> List<T> applyExpressionFilter(List<T> input, ExpressionFilter filter) {
        if (filter == null) {
            return input;
        }
        Logging.log.fine(Logging.format("Apply filter [%s] on [%d] items", filter.getExpression(), input.size()));
        return input.stream().filter(it -> {
            if (filter.matches(new MediaBindingBean(it, null, new EntryList(null, input)))) {
                Logging.log.finest(Logging.format("Include [%s]", it));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    protected <T extends SearchResult> T selectSearchResult(String query, Collection<T> options) throws Exception {
        List<T> matches = this.selectSearchResult(query, options, false, false, false, 1);
        return (T)(matches.size() > 0 ? (SearchResult)matches.get(0) : null);
    }

    protected <T extends SearchResult> List<T> selectSearchResult(String query, Collection<T> options, boolean sort, boolean alias, boolean strict, int limit) throws Exception {
        List<T> probableMatches = MediaDetection.getProbableMatches(sort ? query : null, options, alias, strict);
        if (probableMatches.isEmpty() || strict && probableMatches.size() != 1) {
            if (options.size() == 1 && !strict) {
                return options.stream().collect(Collectors.toList());
            }
            if (strict) {
                throw new CmdlineException("Multiple options: Advanced auto-selection requires -non-strict matching: " + probableMatches);
            }
            if (sort) {
                probableMatches = MediaDetection.sortBySimilarity(options, Collections.singleton(query), MediaDetection.getSeriesMatchMetric()).stream().collect(Collectors.toList());
            }
        }
        return probableMatches.size() <= limit ? probableMatches : probableMatches.subList(0, limit);
    }

    @Override
    public boolean check(Collection<File> files) throws Exception {
        boolean result = true;
        for (File it : FileUtilities.filter(files, MediaTypes.VERIFICATION_FILES)) {
            result &= this.check(it, it.getParentFile());
        }
        return result;
    }

    @Override
    public File compute(Collection<File> files, File output, HashType hash, Charset encoding) throws Exception {
        if ((files = FileUtilities.filter(files, FileUtilities.FILES)).isEmpty()) {
            throw new CmdlineException("No files: " + files);
        }
        File[] fileList = files.toArray(new File[0]);
        Comparable[][] pathArray = new File[fileList.length][];
        for (int i = 0; i < fileList.length; ++i) {
            pathArray[i] = FileUtilities.listPath(fileList[i].getParentFile()).toArray(new File[0]);
        }
        CommonSequenceMatcher csm = new CommonSequenceMatcher(null, 0, true);
        File[] common = (File[])csm.matchFirstCommonSequence(pathArray);
        if (common == null) {
            throw new CmdlineException("All paths must be on the same filesystem: " + files);
        }
        File root = common[common.length - 1];
        if (output == null) {
            output = new File(root, root.getName() + '.' + hash.getFilter().extension());
        } else if (!output.isAbsolute()) {
            output = new File(root, output.getPath());
        }
        Logging.log.info(Logging.format("Compute %s hash for %s files [%s]", new Object[]{hash, files.size(), output}));
        this.compute(root, files, output, hash, encoding);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check(File verificationFile, File root) throws Exception {
        HashType type = VerificationUtilities.getHashType(verificationFile);
        if (type == null) {
            throw new CmdlineException("Unsupported format: " + verificationFile);
        }
        Logging.log.fine(Logging.format("Checking [%s]", verificationFile.getName()));
        boolean status = true;
        try (VerificationFileReader parser = new VerificationFileReader(FileUtilities.createTextReader(verificationFile), type.getFormat());){
            while (parser.hasNext()) {
                try {
                    Object it = parser.next();
                    File file = new File(root, ((File)it.getKey()).getPath()).getAbsoluteFile();
                    String current = VerificationUtilities.computeHash(new File(root, ((File)it.getKey()).getPath()), type);
                    Logging.log.info(Logging.format("%s %s", current, file));
                    if (current.compareToIgnoreCase((String)it.getValue()) == 0) continue;
                    throw new IOException(String.format("Corrupted file found: %s [hash mismatch: %s vs %s]", it.getKey(), current, it.getValue()));
                }
                catch (IOException e) {
                    status = false;
                    Logging.log.warning(e.getMessage());
                }
            }
        }
        return status;
    }

    private void compute(File root, Collection<File> files, File outputFile, HashType hashType, Charset encoding) throws IOException, Exception {
        try (VerificationFileWriter out = new VerificationFileWriter(outputFile, hashType.getFormat(), encoding != null ? encoding : StandardCharsets.UTF_8);){
            for (File it : files) {
                if (it.isHidden() || MediaTypes.VERIFICATION_FILES.accept(it)) continue;
                String relativePath = FileUtilities.normalizePathSeparators(it.getPath().substring(root.getPath().length() + 1));
                String hash = VerificationUtilities.computeHash(it, hashType);
                Logging.log.info(Logging.format("%s %s", hash, relativePath));
                out.write(relativePath, hash);
            }
        }
    }

    private List<Episode> fetchEpisodeList(EpisodeListProvider db, String query, ExpressionFilter filter, SortOrder order, Locale locale, boolean strict) throws Exception {
        if (query == null) {
            throw new CmdlineException(String.format("%s: query parameter is required", db.getName()));
        }
        ArrayList<Episode> episodes = new ArrayList<Episode>();
        if (query.matches("\\d{5,9}")) {
            episodes.addAll(db.getEpisodeList(Integer.parseInt(query), order, locale));
        } else {
            List<SearchResult> options = this.selectSearchResult(query, db.search(query, locale), false, false, false, strict ? 1 : 5);
            for (SearchResult option : options) {
                episodes.addAll(db.getEpisodeList(option, order, locale));
            }
        }
        if (episodes.isEmpty()) {
            throw new CmdlineException(String.format("%s: no results", db.getName()));
        }
        return this.applyExpressionFilter(episodes, filter);
    }

    @Override
    public Stream<String> fetchEpisodeList(EpisodeListProvider db, String query, ExpressionFormat format, ExpressionFilter filter, SortOrder order, Locale locale, boolean strict) throws Exception {
        List<Episode> episodes = this.fetchEpisodeList(db, query, filter, order, locale, strict);
        if (format == null) {
            return episodes.stream().map(Episode::toString);
        }
        return episodes.stream().map(episode -> {
            try {
                return format.format(new MediaBindingBean(episode, null, new EntryList(null, episodes)));
            }
            catch (Exception e) {
                Logging.debug.warning(e::getMessage);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Override
    public Stream<String> getMediaInfo(Collection<File> files, FileFilter filter, ExpressionFormat format) throws Exception {
        if (format == null) {
            return this.getMediaInfo(files, filter, new ExpressionFormat("{fn} [{resolution} {vc} {channels} {ac} {hours}]"));
        }
        return files.stream().filter(filter::accept).map(f -> {
            try {
                return format.format(new MediaBindingBean(XattrMetaInfo.xattr.getMetaInfo((File)f), (File)f));
            }
            catch (Exception e) {
                Logging.debug.warning(e::getMessage);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Override
    public List<File> revert(Collection<File> files, FileFilter filter, RenameAction action) throws Exception {
        if (files.isEmpty()) {
            throw new CmdlineException("Expecting at least one input path");
        }
        HashSet<File> whitelist = new HashSet<File>(files);
        Map<File, File> history = HistorySpooler.getInstance().getCompleteHistory().getRenameMap();
        return history.entrySet().stream().filter(it -> {
            File original = (File)it.getKey();
            File current = (File)it.getValue();
            return Stream.of(current, original).flatMap(f -> FileUtilities.listPath(f).stream()).anyMatch(whitelist::contains) && current.exists() && filter.accept(current);
        }).map(it -> {
            File original = (File)it.getKey();
            File current = (File)it.getValue();
            Logging.log.info(Logging.format("Revert [%s] to [%s]", current, original));
            if (action.canRevert()) {
                try {
                    return StandardRenameAction.revert(current, original);
                }
                catch (Exception e) {
                    Logging.log.warning("Failed to revert file: " + e);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> extract(Collection<File> files, File output, ConflictAction conflict, FileFilter filter, boolean forceExtractAll) throws Exception {
        List<File> archiveFiles = FileUtilities.filter(files, Archive.VOLUME_ONE_FILTER);
        ArrayList<File> extractedFiles = new ArrayList<File>();
        for (File file : archiveFiles) {
            try (Archive archive = Archive.open(file);){
                int n;
                File outputFolder = output;
                if (outputFolder == null || !outputFolder.isAbsolute()) {
                    outputFolder = new File(file.getParentFile(), outputFolder == null ? FileUtilities.getName(file) : outputFolder.getPath()).getCanonicalFile();
                }
                Logging.log.info(Logging.format("Read archive [%s] and extract to [%s]", file.getName(), outputFolder));
                final FileMapper outputMapper = new FileMapper(outputFolder);
                ArrayList<SimpleFileInfo> outputMapping = new ArrayList<SimpleFileInfo>();
                for (FileInfo fileInfo : archive.listFiles()) {
                    File outputPath = outputMapper.getOutputFile(fileInfo.toFile());
                    outputMapping.add(new SimpleFileInfo(outputPath.getPath(), fileInfo.getLength()));
                }
                final TreeSet<FileInfo> selection = new TreeSet<FileInfo>();
                for (FileInfo future : outputMapping) {
                    if (filter != null && !filter.accept(future.toFile())) continue;
                    selection.add(future);
                }
                if (selection.isEmpty()) continue;
                boolean bl = true;
                for (FileInfo fileInfo : filter == null || forceExtractAll ? outputMapping : selection) {
                    if (conflict == ConflictAction.AUTO) {
                        n &= fileInfo.toFile().exists() && fileInfo.getLength() == fileInfo.toFile().length() ? 1 : 0;
                        continue;
                    }
                    n &= fileInfo.toFile().exists();
                }
                if (n == 0 || conflict == ConflictAction.OVERRIDE) {
                    if (filter == null || forceExtractAll) {
                        Logging.log.finest("Extracting files " + outputMapping);
                        archive.extract(outputMapper.getOutputDir());
                        for (FileInfo fileInfo : outputMapping) {
                            extractedFiles.add(fileInfo.toFile());
                        }
                        continue;
                    }
                    Logging.log.finest("Extracting files " + selection);
                    archive.extract(outputMapper.getOutputDir(), new FileFilter(){

                        @Override
                        public boolean accept(File entry) {
                            return selection.contains(outputMapper.getOutputFile(entry));
                        }
                    });
                    for (FileInfo fileInfo : selection) {
                        extractedFiles.add(fileInfo.toFile());
                    }
                    continue;
                }
                Logging.log.finest("Skipped extracting files " + selection);
            }
        }
        return extractedFiles;
    }
}

