/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingPropertyException;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.lang.model.SourceVersion;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.filebot.format.BindingException;
import net.filebot.format.ExpressionBindings;
import net.filebot.format.ExpressionException;
import net.filebot.format.ExpressionFormatFunctions;
import net.filebot.format.PrivilegedInvocation;
import net.filebot.format.SecureCompiledScript;
import net.filebot.format.SuppressedThrowables;
import net.filebot.util.ExceptionUtilities;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;

public class ExpressionFormat
extends Format {
    private final String expression;
    private final Object[] compilation;
    private SuppressedThrowables suppressed;
    private static ScriptEngine engine;
    private static Map<String, CompiledScript> scriptletCache;

    public ExpressionFormat(String expression) throws ScriptException {
        this.expression = expression;
        this.compilation = this.secure(this.compile(expression));
    }

    public String getExpression() {
        return this.expression;
    }

    protected Object[] compile(String expression) throws ScriptException {
        ArrayList<Object> compilation = new ArrayList<Object>();
        char open = '{';
        char close = '}';
        StringBuilder token = new StringBuilder();
        int level = 0;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == open) {
                if (level == 0) {
                    if (token.length() > 0) {
                        compilation.add(token.toString());
                        token.setLength(0);
                    }
                } else {
                    token.append(c);
                }
                ++level;
            } else if (c == close) {
                if (level == 1) {
                    if (token.length() > 0) {
                        try {
                            compilation.add(ExpressionFormat.compileScriptlet(token.toString()));
                        }
                        catch (ScriptException e) {
                            ScriptException illegalSyntax = e;
                            try {
                                String message = ExceptionUtilities.findCause(e, MultipleCompilationErrorsException.class).getErrorCollector().getSyntaxError(0).getOriginalMessage();
                                illegalSyntax = new ScriptException("SyntaxError: " + message);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw illegalSyntax;
                        }
                        finally {
                            token.setLength(0);
                        }
                    }
                } else {
                    token.append(c);
                }
                --level;
            } else {
                token.append(c);
            }
            if (level >= 0) continue;
            throw new ScriptException("SyntaxError: unexpected token: " + close);
        }
        if (level != 0) {
            throw new ScriptException("SyntaxError: missing token: " + close);
        }
        if (token.length() > 0) {
            compilation.add(token.toString());
        }
        return compilation.toArray();
    }

    public Bindings getBindings(Object value) {
        return new ExpressionBindings(value);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer sb, FieldPosition pos) {
        return sb.append(this.format(this.getBindings(object)));
    }

    public String format(Bindings bindings) {
        Bindings priviledgedBindings = PrivilegedInvocation.newProxy(Bindings.class, bindings, AccessController.getContext());
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(priviledgedBindings, 200);
        ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
        StringBuilder sb = new StringBuilder();
        for (Object snippet : this.compilation) {
            if (snippet instanceof CompiledScript) {
                try {
                    CharSequence value = this.normalizeExpressionValue(((CompiledScript)snippet).eval(context));
                    if (value == null) continue;
                    sb.append(value);
                }
                catch (ScriptException e) {
                    suppressed.add(this.normalizeExpressionException(e));
                }
                continue;
            }
            sb.append(snippet);
        }
        String value = this.normalizeResult(sb);
        if (value.isEmpty()) {
            throw new SuppressedThrowables("Expression yields empty value", suppressed);
        }
        this.suppressed = suppressed.isEmpty() ? null : new SuppressedThrowables("Suppressed", suppressed);
        return value;
    }

    public SuppressedThrowables suppressed() {
        return this.suppressed;
    }

    protected Object normalizeBindingValue(Object value) {
        return value;
    }

    protected CharSequence normalizeExpressionValue(Object value) {
        return value == null ? null : value.toString();
    }

    protected String normalizeResult(CharSequence value) {
        return value.toString();
    }

    protected Throwable normalizeExpressionException(ScriptException exception) {
        if (ExceptionUtilities.findCause(exception, MissingPropertyException.class) != null) {
            return new BindingException(ExceptionUtilities.findCause(exception, MissingPropertyException.class).getProperty(), "undefined", exception);
        }
        if (ExceptionUtilities.findCause(exception, GroovyRuntimeException.class) != null) {
            return new ExpressionException(ExceptionUtilities.findCause(exception, GroovyRuntimeException.class).getMessage(), exception);
        }
        if (exception.getCause() instanceof Exception) {
            return exception.getCause();
        }
        return exception;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    private Object[] secure(Object[] compilation) {
        for (int i = 0; i < compilation.length; ++i) {
            Object snippet = compilation[i];
            if (snippet instanceof Variable || !(snippet instanceof CompiledScript)) continue;
            compilation[i] = new SecureCompiledScript((CompiledScript)snippet);
        }
        return compilation;
    }

    protected static ScriptEngine createScriptEngine() {
        CompilerConfiguration config = new CompilerConfiguration();
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStaticStars(ExpressionFormatFunctions.class.getName());
        config.addCompilationCustomizers(imports);
        GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        return new GroovyScriptEngineImpl(classLoader);
    }

    protected static synchronized ScriptEngine getGroovyScriptEngine() throws ScriptException {
        if (engine == null) {
            engine = ExpressionFormat.createScriptEngine();
        }
        return engine;
    }

    protected static synchronized CompiledScript compileScriptlet(String expression) throws ScriptException {
        if (SourceVersion.isIdentifier(expression) && !SourceVersion.isKeyword(expression)) {
            return new Variable(expression);
        }
        CompiledScript scriptlet = scriptletCache.get(expression);
        if (scriptlet == null) {
            Compilable engine = (Compilable)((Object)ExpressionFormat.getGroovyScriptEngine());
            scriptlet = engine.compile(expression);
            scriptletCache.put(expression, scriptlet);
        }
        return scriptlet;
    }

    static {
        scriptletCache = new HashMap<String, CompiledScript>();
    }

    private static class Variable
    extends CompiledScript {
        private String name;

        public Variable(String name) {
            this.name = name;
        }

        @Override
        public Object eval(ScriptContext context) throws ScriptException {
            try {
                Object value = context.getAttribute(this.name);
                if (value == null) {
                    throw new MissingPropertyException(this.name, Variable.class);
                }
                return value;
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
            catch (Throwable t) {
                throw new ScriptException(new ExecutionException(t));
            }
        }

        @Override
        public ScriptEngine getEngine() {
            return null;
        }
    }
}

