/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.io.File;
import java.text.ParseException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.filebot.hash.VerificationFormat;

public class SfvFormat
extends VerificationFormat {
    private final Pattern pattern = Pattern.compile("^(.+)\\s+(\\p{XDigit}{8})$");

    @Override
    public String format(String path, String hash) {
        return String.format("%s %s", path, hash);
    }

    @Override
    public Map.Entry<File, String> parseObject(String line) throws ParseException {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.matches()) {
            throw new ParseException("Illegal input pattern", 0);
        }
        return this.entry(matcher.group(1), matcher.group(2));
    }
}

