/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.mediainfo;

import java.io.File;
import java.io.FileFilter;
import net.filebot.Logging;
import net.filebot.mediainfo.MediaInfo;

public class MediaDurationFilter
implements FileFilter {
    private final long min;
    private final long max;
    private final boolean acceptByDefault;

    public MediaDurationFilter(long min) {
        this(min, Long.MAX_VALUE, false);
    }

    public MediaDurationFilter(long min, long max, boolean acceptByDefault) {
        this.min = min;
        this.max = max;
        this.acceptByDefault = acceptByDefault;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration(File f) {
        try (MediaInfo mi = new MediaInfo().open(f);){
            String duration = mi.get(MediaInfo.StreamKind.General, 0, "Duration");
            if (duration.length() <= 0) return -1L;
            long l = Long.parseLong(duration);
            return l;
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Failed to read video duration: %s", e.getMessage()));
        }
        return -1L;
    }

    @Override
    public boolean accept(File f) {
        long d = this.getDuration(f);
        if (d >= 0L) {
            return d >= this.min && d <= this.max;
        }
        return this.acceptByDefault;
    }
}

