/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.web.SimpleDate;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;

public class DateMatcher {
    public static final DateFilter DEFAULT_SANITY = new DateFilter(1930, 2050);
    private final DatePattern[] patterns;

    public DateMatcher(DateFilter sanity, Locale ... locale) {
        String[] format = new String[]{"y M d", "d M y", "y MMMM d", "y MMM d", "d MMMM y", "d MMM y", "yyyyMMdd"};
        this.patterns = this.compile(format, sanity, locale);
    }

    protected DatePattern[] compile(String[] pattern, DateFilter sanity, Locale ... locale) {
        return (DatePattern[])((AbstractStreamEx)StreamEx.of(pattern).flatMap(dateFormat -> ((AbstractStreamEx)((StreamEx)StreamEx.of(locale).distinct(Locale::getLanguage)).map(formatLocale -> {
            String regex = ((StreamEx)StreamEx.split((CharSequence)dateFormat, " ").map(g -> this.getPatternGroup((String)g, (Locale)formatLocale))).joining("\\D", "(?<!\\p{Alnum})", "(?!\\p{Alnum})");
            return new DateFormatPattern(regex, (String)dateFormat, (Locale)formatLocale, sanity);
        })).distinct(DateFormatPattern::toString))).toArray(DateFormatPattern[]::new);
    }

    protected String getPatternGroup(String token, Locale locale) {
        switch (token) {
            case "y": {
                return "(\\d{4})";
            }
            case "M": {
                return "(\\d{1,2})";
            }
            case "d": {
                return "(\\d{1,2})";
            }
            case "yyyyMMdd": {
                return "(\\d{8})";
            }
            case "MMMM": {
                return this.getMonthNamePatternGroup(TextStyle.FULL, locale);
            }
            case "MMM": {
                return this.getMonthNamePatternGroup(TextStyle.SHORT, locale);
            }
        }
        throw new IllegalArgumentException(token);
    }

    protected String getMonthNamePatternGroup(TextStyle style, Locale locale) {
        return ((StreamEx)((AbstractStreamEx)StreamEx.of(Month.values()).map(m -> m.getDisplayName(style, locale))).map(Pattern::quote)).joining("|", "(", ")");
    }

    public SimpleDate match(CharSequence seq) {
        for (DatePattern pattern : this.patterns) {
            SimpleDate match = pattern.match(seq);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public int find(CharSequence seq, int fromIndex) {
        for (DatePattern pattern : this.patterns) {
            int pos = pattern.find(seq, fromIndex);
            if (pos < 0) continue;
            return pos;
        }
        return -1;
    }

    public SimpleDate match(File file) {
        for (String name : this.tokenizeTail(file)) {
            for (DatePattern pattern : this.patterns) {
                SimpleDate match = pattern.match(name);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    protected List<String> tokenizeTail(File file) {
        ArrayList<String> tail = new ArrayList<String>(2);
        for (File f : FileUtilities.listPathTail(file, 2, true)) {
            tail.add(FileUtilities.getName(f));
        }
        return tail;
    }

    public static class DateFilter
    implements Predicate<LocalDate> {
        public final LocalDate min;
        public final LocalDate max;
        private final int minYear;
        private final int maxYear;

        public DateFilter(LocalDate min, LocalDate max) {
            this.min = min;
            this.max = max;
            this.minYear = min.getYear();
            this.maxYear = max.getYear();
        }

        public DateFilter(int minYear, int maxYear) {
            this.min = LocalDate.of(minYear, Month.JANUARY, 1);
            this.max = LocalDate.of(maxYear, Month.JANUARY, 1);
            this.minYear = minYear;
            this.maxYear = maxYear;
        }

        @Override
        public boolean test(LocalDate date) {
            return date.isAfter(this.min) && date.isBefore(this.max);
        }

        public boolean acceptYear(int year) {
            return this.minYear <= year && year <= this.maxYear;
        }

        public boolean acceptDate(int year, int month, int day) {
            return this.acceptYear(year) && this.test(LocalDate.of(year, month, day));
        }
    }

    public static class DateFormatPattern
    implements DatePattern {
        public static final String DELIMITER = " ";
        public final Pattern pattern;
        public final DateTimeFormatter format;
        public final DateFilter sanity;

        public DateFormatPattern(String pattern, String format, Locale locale, DateFilter sanity) {
            this.pattern = Pattern.compile(pattern, 2);
            this.format = DateTimeFormatter.ofPattern(format, locale);
            this.sanity = sanity;
        }

        protected SimpleDate process(MatchResult match) {
            try {
                String dateString = StringUtilities.streamCapturingGroups(match).collect(Collectors.joining(DELIMITER));
                LocalDate date = LocalDate.parse(dateString, this.format);
                if (this.sanity == null || this.sanity.test(date)) {
                    return new SimpleDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
                }
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public SimpleDate match(CharSequence seq) {
            Matcher matcher = this.pattern.matcher(seq);
            if (matcher.find()) {
                return this.process(matcher);
            }
            return null;
        }

        @Override
        public int find(CharSequence seq, int fromIndex) {
            Matcher matcher = this.pattern.matcher(seq).region(fromIndex, seq.length());
            if (matcher.find() && this.process(matcher) != null) {
                return matcher.start();
            }
            return -1;
        }

        public String toString() {
            return this.pattern.pattern();
        }
    }

    public static interface DatePattern {
        public SimpleDate match(CharSequence var1);

        public int find(CharSequence var1, int var2);
    }
}

