/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.SimilarityMetric;

public class SimilarityComparator<T, P>
implements Comparator<T> {
    protected SimilarityMetric metric;
    protected Collection<P> paragon;
    protected Function<T, Collection<P>> mapper;
    private static final double ZERO = 0.0;

    public static <T, S extends CharSequence> SimilarityComparator<T, S> compareTo(S value, Function<T, S> mapper) {
        return new SimilarityComparator<T, S>(new NameSimilarityMetric(), Collections.singleton(value), mapper.andThen(Collections::singleton));
    }

    public SimilarityComparator(SimilarityMetric metric, Collection<P> paragon, Function<T, Collection<P>> mapper) {
        this.metric = metric;
        this.paragon = paragon;
        this.mapper = mapper;
    }

    @Override
    public int compare(T o1, T o2) {
        return Double.compare(this.getSimilarity(o2), this.getSimilarity(o1));
    }

    public double getSimilarity(T value) {
        return this.paragon.stream().mapToDouble(it -> this.accumulateSimilarity(it, value)).average().orElse(0.0);
    }

    private double accumulateSimilarity(P paragon, T value) {
        if (paragon == null) {
            return 0.0;
        }
        return this.mapper.apply(value).stream().mapToDouble(it -> it == null ? 0.0 : (double)this.metric.getSimilarity(paragon, it)).max().orElse(0.0);
    }
}

