/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.temporal.ChronoUnit;
import net.filebot.similarity.SimilarityMetric;

public class TimeStampMetric
implements SimilarityMetric {
    private long epoch;

    public TimeStampMetric(int i, ChronoUnit unit) {
        this.epoch = unit.getDuration().multipliedBy(i).toMillis();
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        long t1 = this.getTimeStamp(o1);
        long t2 = this.getTimeStamp(o2);
        if (t1 > 0L && t2 > 0L) {
            float delta = Math.abs(t1 - t2);
            return delta > (float)this.epoch ? 0.0f : 1.0f - delta / (float)this.epoch;
        }
        return -1.0f;
    }

    public long getTimeStamp(Object object) {
        if (object instanceof File) {
            File f = (File)object;
            try {
                BasicFileAttributes attr = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                long creationTime = attr.creationTime().toMillis();
                if (creationTime > 0L) {
                    return creationTime;
                }
                return attr.lastModifiedTime().toMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }
}

