/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.util.ArrayList;
import java.util.Scanner;
import net.filebot.subtitle.SubtitleElement;
import net.filebot.subtitle.SubtitleReader;
import net.filebot.util.RegularExpressions;
import net.filebot.util.StringUtilities;

public class MicroDVDReader
extends SubtitleReader {
    private double fps = 23.976;

    public MicroDVDReader(Scanner scanner) {
        super(scanner);
    }

    @Override
    public SubtitleElement readNext() throws Exception {
        int to;
        String line = this.scanner.nextLine();
        ArrayList<String> properties = new ArrayList<String>(2);
        int from = 0;
        while (from < line.length() && line.charAt(from) == '{' && (to = line.indexOf(125, from + 1)) >= from) {
            properties.add(line.substring(from + 1, to));
            from = to + 1;
        }
        if (properties.size() < 2) {
            return null;
        }
        int startFrame = Integer.parseInt((String)properties.get(0));
        int endFrame = Integer.parseInt((String)properties.get(1));
        String text = line.substring(from).trim();
        text = text.replaceAll("\\{[^\\}]*\\}", "");
        if (startFrame == 1 && endFrame == 1) {
            this.fps = Double.parseDouble(text);
            return null;
        }
        Object[] lines = RegularExpressions.PIPE.split(text);
        return new SubtitleElement(Math.round((double)startFrame * this.fps), Math.round((double)endFrame * this.fps), StringUtilities.join(lines, (CharSequence)"\n"));
    }
}

