/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.web.SubtitleDescriptor;

public enum SubtitleNaming {
    ORIGINAL{

        @Override
        public String format(File video, SubtitleDescriptor subtitle, String ext) {
            return String.format("%s.%s", subtitle.getName(), ext);
        }

        public String toString() {
            return "Keep Original";
        }
    }
    ,
    MATCH_VIDEO{

        @Override
        public String format(File video, SubtitleDescriptor subtitle, String ext) {
            return SubtitleUtilities.formatSubtitle(FileUtilities.getName(video), null, ext);
        }

        public String toString() {
            return "Match Video";
        }
    }
    ,
    MATCH_VIDEO_ADD_LANGUAGE_TAG{

        @Override
        public String format(File video, SubtitleDescriptor subtitle, String ext) {
            return SubtitleUtilities.formatSubtitle(FileUtilities.getName(video), subtitle.getLanguageName(), ext);
        }

        public String toString() {
            return "Match Video and Language";
        }
    };


    public abstract String format(File var1, SubtitleDescriptor var2, String var3);

    public static List<String> names() {
        return Arrays.stream(SubtitleNaming.values()).map(Enum::name).collect(Collectors.toList());
    }

    public static SubtitleNaming forName(String name) {
        for (SubtitleNaming naming : SubtitleNaming.values()) {
            if (!naming.name().equalsIgnoreCase(name)) continue;
            return naming;
        }
        throw new IllegalArgumentException(String.format("%s not in %s", name, SubtitleNaming.names()));
    }
}

