/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.filebot.ui.FileBotTabComponent;

public class FileBotTab<T extends JComponent>
extends JComponent {
    private final FileBotTabComponent tabComponent = new FileBotTabComponent();
    private final T component;
    private final ActionListener closeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FileBotTab.this.close();
        }
    };

    public FileBotTab(T component) {
        this.component = component;
        this.tabComponent.getCloseButton().addActionListener(this.closeAction);
        this.setLayout(new BorderLayout());
        this.add((Component)component, "Center");
    }

    public void addTo(JTabbedPane tabbedPane) {
        tabbedPane.addTab(this.getTitle(), this);
        tabbedPane.setTabComponentAt(tabbedPane.indexOfComponent(this), this.tabComponent);
    }

    public void close() {
        if (!this.isClosed()) {
            this.getTabbedPane().remove(this);
        }
    }

    public boolean isClosed() {
        JTabbedPane tabbedPane = this.getTabbedPane();
        if (tabbedPane == null) {
            return true;
        }
        return this.getTabbedPane().indexOfComponent(this) < 0;
    }

    private JTabbedPane getTabbedPane() {
        return (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, this);
    }

    public T getComponent() {
        return this.component;
    }

    public FileBotTabComponent getTabComponent() {
        return this.tabComponent;
    }

    public void setTitle(String title) {
        this.tabComponent.setText(title);
    }

    public String getTitle() {
        return this.tabComponent.getText();
    }

    public void setIcon(Icon icon) {
        this.tabComponent.setIcon(icon);
    }

    public Icon getIcon() {
        return this.tabComponent.getIcon();
    }

    public void setLoading(boolean loading) {
        this.tabComponent.setLoading(loading);
    }
}

