/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.filebot.Language;
import net.filebot.Settings;
import net.filebot.ui.LanguageComboBoxCellRenderer;
import net.filebot.ui.LanguageComboBoxModel;

public class LanguageComboBox
extends JComboBox {
    private Map.Entry<String, String> persistentSelectedLanguage;
    private List<String> persistentFavoriteLanguages;

    public LanguageComboBox(Language initialSelection, Settings settings) {
        super(new LanguageComboBoxModel(initialSelection, initialSelection));
        this.setRenderer(new LanguageComboBoxCellRenderer(super.getRenderer()));
        if (settings != null) {
            this.persistentSelectedLanguage = settings.entry("language.selected");
            this.persistentFavoriteLanguages = settings.node("language.favorites").asList();
        } else {
            this.persistentSelectedLanguage = new AbstractMap.SimpleEntry<Object, Object>(null, null);
            this.persistentFavoriteLanguages = new ArrayList<String>();
        }
        try {
            this.getModel().setSelectedItem(Language.getLanguage(this.persistentSelectedLanguage.getValue()));
        }
        catch (Exception e) {
            this.getModel().setSelectedItem(LanguageComboBoxModel.ALL_LANGUAGES);
        }
        for (String favoriteLanguage : this.persistentFavoriteLanguages) {
            Language language = Language.getLanguage(favoriteLanguage);
            if (language == null) continue;
            this.getModel().favorites().add(this.getModel().favorites().size(), language);
        }
        if (this.getModel().favorites().isEmpty()) {
            for (Locale locale : new Locale[]{Locale.ENGLISH, Locale.getDefault()}) {
                this.getModel().favorites().add(Language.getLanguage(locale.getLanguage()));
            }
        }
        this.addPopupMenuListener(new PopupSelectionListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Language language = (Language)e.getItem();
                if (LanguageComboBox.this.getModel().favorites().add(language)) {
                    LanguageComboBox.this.persistentFavoriteLanguages.clear();
                    LanguageComboBox.this.persistentFavoriteLanguages.addAll(new AbstractList<String>(){

                        @Override
                        public String get(int index) {
                            return LanguageComboBox.this.getModel().favorites().get(index).getCode();
                        }

                        @Override
                        public int size() {
                            return LanguageComboBox.this.getModel().favorites().size();
                        }
                    });
                }
                LanguageComboBox.this.persistentSelectedLanguage.setValue(language.getCode());
            }
        });
    }

    public LanguageComboBoxModel getModel() {
        return (LanguageComboBoxModel)super.getModel();
    }

    private static class PopupSelectionListener
    implements PopupMenuListener,
    ItemListener {
        private Object selected = null;

        private PopupSelectionListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            this.selected = comboBox.getSelectedItem();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (this.selected != comboBox.getSelectedItem()) {
                this.itemStateChanged(new ItemEvent(comboBox, 701, comboBox.getSelectedItem(), 1));
            }
            this.selected = null;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.selected = null;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }
    }
}

