/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.filebot.CacheManager;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.cli.GroovyPad;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.GettingStartedStage;
import net.filebot.ui.HeaderPanel;
import net.filebot.ui.PanelBuilder;
import net.filebot.util.PreferencesMap;
import net.filebot.util.ui.DefaultFancyListCellRenderer;
import net.filebot.util.ui.ShadowBorder;
import net.filebot.util.ui.SwingEventBus;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

public class MainFrame
extends JFrame {
    private static final PreferencesMap.PreferencesEntry<String> persistentSelectedPanel = Settings.forPackage(MainFrame.class).entry("panel.selected").defaultValue("0");
    private JList selectionList;
    private HeaderPanel headerPanel;

    public MainFrame(PanelBuilder[] panels) {
        super(Settings.isAutoUpdateEnabled() ? Settings.getApplicationName() : String.format("%s %s", Settings.getApplicationName(), Settings.getApplicationVersion()));
        this.selectionList = new PanelSelectionList(panels);
        this.headerPanel = new HeaderPanel();
        JScrollPane selectionListScrollPane = new JScrollPane(this.selectionList, 21, 31);
        selectionListScrollPane.setOpaque(false);
        selectionListScrollPane.setBorder(BorderFactory.createCompoundBorder(new ShadowBorder(), Settings.isMacApp() ? BorderFactory.createLineBorder(new Color(8428984), 1, false) : selectionListScrollPane.getBorder()));
        this.headerPanel.getTitleLabel().setBorder(BorderFactory.createEmptyBorder(8, 90, 10, 0));
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new MigLayout("insets 0, fill, hidemode 3", String.format("%dpx[fill]", Settings.isUbuntuApp() ? 110 : 95), "fill"));
        c.add((Component)selectionListScrollPane, "pos 6px 10px n 100%-12px");
        c.add((Component)this.headerPanel, "growx, dock north");
        try {
            this.selectionList.setSelectedIndex(Integer.parseInt(persistentSelectedPanel.getValue()));
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::getMessage);
        }
        try {
            this.showPanel((PanelBuilder)this.selectionList.getSelectedValue());
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::getMessage);
        }
        this.selectionList.addListSelectionListener(evt -> {
            this.showPanel((PanelBuilder)this.selectionList.getSelectedValue());
            if (!evt.getValueIsAdjusting()) {
                persistentSelectedPanel.setValue(Integer.toString(this.selectionList.getSelectedIndex()));
            }
        });
        this.setSize(1060, 650);
        SwingUI.installAction(this.getRootPane(), KeyStroke.getKeyStroke(127, 3), SwingUI.newAction("Clear Cache", evt -> SwingUI.withWaitCursor(this.getRootPane(), () -> {
            CacheManager.getInstance().clearAll();
            Logging.log.info("Cache has been cleared");
        })));
        SwingUI.installAction(this.getRootPane(), KeyStroke.getKeyStroke(116, 0), SwingUI.newAction("Run", evt -> SwingUI.withWaitCursor(this.getRootPane(), () -> {
            GroovyPad pad = new GroovyPad();
            pad.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    MainFrame.this.setVisible(false);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    MainFrame.this.setVisible(true);
                }
            });
            pad.setDefaultCloseOperation(2);
            pad.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
            pad.setLocationByPlatform(true);
            pad.setVisible(true);
        })));
        SwingUI.installAction(this.getRootPane(), KeyStroke.getKeyStroke(112, 0), SwingUI.newAction("Help", evt -> GettingStartedStage.start()));
        SwingEventBus.getInstance().register(this);
    }

    @Subscribe
    public void selectPanel(PanelBuilder panel) {
        this.selectionList.setSelectedValue(panel, false);
    }

    private void showPanel(PanelBuilder selectedBuilder) {
        if (selectedBuilder == null) {
            return;
        }
        JComponent contentPane = (JComponent)this.getContentPane();
        Component selectedPanel = null;
        for (int i = 0; i < contentPane.getComponentCount(); ++i) {
            JComponent panel = (JComponent)contentPane.getComponent(i);
            PanelBuilder builder = (PanelBuilder)panel.getClientProperty(PanelBuilder.class.getName());
            if (builder == null) continue;
            if (builder.equals(selectedBuilder)) {
                selectedPanel = panel;
                continue;
            }
            if (!panel.isVisible()) continue;
            panel.setVisible(false);
            SwingEventBus.getInstance().unregister(panel);
        }
        if (selectedPanel == null) {
            selectedPanel = selectedBuilder.create();
            ((JComponent)selectedPanel).setVisible(false);
            ((JComponent)selectedPanel).putClientProperty(PanelBuilder.class.getName(), selectedBuilder);
            contentPane.add(selectedPanel);
        }
        if (!selectedPanel.isVisible()) {
            this.headerPanel.setTitle(selectedBuilder.getName());
            ((JComponent)selectedPanel).setVisible(true);
            SwingEventBus.getInstance().register(selectedPanel);
        }
    }

    private static class PanelCellRenderer
    extends DefaultFancyListCellRenderer {
        public PanelCellRenderer() {
            super(10, 0, new Color(1454692));
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setHighlightingEnabled(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }

        @Override
        public void configureListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.configureListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            PanelBuilder panel = (PanelBuilder)value;
            this.setText(panel.getName());
            this.setIcon(panel.getIcon());
        }
    }

    private static class PanelSelectionList
    extends JList {
        private static final int SELECTDELAY_ON_DRAG_OVER = 300;

        public PanelSelectionList(PanelBuilder[] builders) {
            super(builders);
            this.setCellRenderer(new PanelCellRenderer());
            this.setPrototypeCellValue(Arrays.stream(builders).max(Comparator.comparingInt(p -> p.getName().length())).get());
            this.setSelectionMode(0);
            this.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            new DropTarget(this, new DragDropListener());
        }

        private class DragDropListener
        extends DropTargetAdapter {
            private boolean selectEnabled = false;
            private Timer dragEnterTimer;

            private DragDropListener() {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                if (this.selectEnabled) {
                    int index = PanelSelectionList.this.locationToIndex(dtde.getLocation());
                    PanelSelectionList.this.setSelectedIndex(index);
                }
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                this.dragEnterTimer = SwingUI.invokeLater(300, () -> {
                    this.selectEnabled = true;
                    if (Settings.isMacApp()) {
                        MacAppUtilities.requestForeground();
                    } else {
                        SwingUtilities.getWindowAncestor(((DropTarget)dtde.getSource()).getComponent()).toFront();
                    }
                });
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                this.selectEnabled = false;
                if (this.dragEnterTimer != null) {
                    this.dragEnterTimer.stop();
                }
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
            }
        }
    }
}

