/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.util.ui.SelectButton;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

public class SelectButtonTextField<T>
extends JComponent {
    private SelectButton<T> selectButton = new SelectButton();
    private JComboBox<Object> editor = new JComboBox();
    private final ActionListener textFieldFocusOnClick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectButtonTextField.this.getEditor().requestFocus();
        }
    };

    public SelectButtonTextField() {
        this.selectButton.addActionListener(this.textFieldFocusOnClick);
        this.editor.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, ((LineBorder)this.selectButton.getBorder()).getLineColor()));
        this.setLayout(new MigLayout("fill, nogrid, novisualpadding"));
        this.add(this.selectButton, "h pref!, w pref!, sizegroupy editor");
        this.add(this.editor, "gap 0, w 195px!, sizegroupy editor");
        this.editor.setPrototypeDisplayValue("X");
        this.editor.setRenderer(new CompletionCellRenderer());
        this.editor.setUI(new TextFieldComboBoxUI(this.selectButton));
        this.editor.setMaximumRowCount(10);
        SwingUI.installAction(this, KeyStroke.getKeyStroke(38, 2), new SpinClientAction(-1));
        SwingUI.installAction(this, KeyStroke.getKeyStroke(40, 2), new SpinClientAction(1));
    }

    public String getText() {
        return ((TextFieldComboBoxUI)this.editor.getUI()).getEditor().getText();
    }

    public JComboBox getEditor() {
        return this.editor;
    }

    public SelectButton<T> getSelectButton() {
        return this.selectButton;
    }

    private static class TextFieldComboBoxUI
    extends BasicComboBoxUI {
        private SelectButton<?> button;

        public TextFieldComboBoxUI(SelectButton<?> button) {
            this.button = button;
        }

        @Override
        protected JButton createArrowButton() {
            return new JButton(ResourceManager.getIcon("action.list"));
        }

        @Override
        public void configureArrowButton() {
            super.configureArrowButton();
            this.arrowButton.setBackground(Color.white);
            this.arrowButton.setOpaque(true);
            this.arrowButton.setBorder(BorderFactory.createEmptyBorder());
            this.arrowButton.setContentAreaFilled(false);
            this.arrowButton.setFocusPainted(false);
            this.arrowButton.setFocusable(false);
            if (Settings.isMacApp()) {
                this.arrowButton.setContentAreaFilled(true);
            }
        }

        @Override
        protected void configureEditor() {
            JTextComponent editor = this.getEditor();
            editor.setEnabled(this.comboBox.isEnabled());
            editor.setFocusable(this.comboBox.isFocusable());
            editor.setFont(this.comboBox.getFont());
            editor.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            editor.addFocusListener(this.createFocusListener());
            editor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    popup.getList().repaint();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    popup.getList().repaint();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    popup.getList().repaint();
                }
            });
            this.popup.getList().setPrototypeCellValue("X");
        }

        public JTextComponent getEditor() {
            return (JTextComponent)this.editor;
        }

        @Override
        protected ComboPopup createPopup() {
            return new BasicComboPopup(this.comboBox){

                @Override
                public void show(Component invoker, int x, int y) {
                    super.show(invoker, x - button.getWidth(), y);
                }

                @Override
                protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                    Rectangle bounds = super.computePopupBounds(px, py, pw, ph);
                    bounds.width += button.getWidth();
                    return bounds;
                }
            };
        }

        @Override
        protected FocusListener createFocusListener() {
            return new BasicComboBoxUI.FocusHandler(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (this.isPopupVisible(comboBox)) {
                        this.setPopupVisible(comboBox, false);
                    }
                }
            };
        }
    }

    private class CompletionCellRenderer
    extends DefaultListCellRenderer {
        private CompletionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setBorder(new EmptyBorder(1, 4, 1, 4));
            String highlightText = SelectButtonTextField.this.getText().substring(0, ((TextFieldComboBoxUI)SelectButtonTextField.this.editor.getUI()).getEditor().getSelectionStart());
            Matcher matcher = Pattern.compile(highlightText, 18).matcher(value.toString());
            StringBuffer htmlText = new StringBuffer("<html><nobr>");
            if (matcher.find()) {
                if (isSelected) {
                    matcher.appendReplacement(htmlText, "<span style='font-weight: bold;'>$0</span>");
                } else {
                    matcher.appendReplacement(htmlText, "<span style='color: " + SwingUI.toHex(list.getSelectionBackground()) + "; font-weight: bold;'>$0</span>");
                }
            }
            matcher.appendTail(htmlText);
            htmlText.append("</nobr></html>");
            this.setText(htmlText.toString());
            return this;
        }
    }

    private class SpinClientAction
    extends AbstractAction {
        private int spin;

        public SpinClientAction(int spin) {
            super(String.format("Spin%+d", spin));
            this.spin = spin;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectButtonTextField.this.selectButton.spinValue(this.spin);
        }
    }
}

