/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.filebot.MediaTypes;
import net.filebot.media.XattrMetaInfo;
import net.filebot.ui.filter.Tool;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.LoadingOverlayPane;
import net.filebot.web.Episode;
import net.filebot.web.Movie;
import net.filebot.web.SeriesInfo;
import net.miginfocom.swing.MigLayout;

class AttributeTool
extends Tool<TableModel> {
    private JTable table = new JTable(new FileAttributesTableModel());

    public AttributeTool() {
        super("Attributes");
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(2);
        this.table.setSelectionMode(2);
        this.table.setBackground(Color.white);
        this.table.setGridColor(new Color(0xEEEEEE));
        this.table.setRowHeight(25);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new MigLayout("insets 0, fill"));
        this.add((Component)new LoadingOverlayPane(scrollPane, this), "grow");
    }

    @Override
    protected TableModel createModelInBackground(List<File> root) {
        FileAttributesTableModel model = new FileAttributesTableModel();
        if (root.isEmpty()) {
            return model;
        }
        List<File> files = FileUtilities.listFiles(root, FileUtilities.filter(MediaTypes.VIDEO_FILES, MediaTypes.SUBTITLE_FILES), FileUtilities.HUMAN_NAME_ORDER);
        for (File file : files) {
            Object metaObject = XattrMetaInfo.xattr.getMetaInfo(file);
            String originalName = XattrMetaInfo.xattr.getOriginalName(file);
            if (metaObject instanceof Episode) {
                SeriesInfo seriesInfo = ((Episode)metaObject).getSeriesInfo();
                if (seriesInfo != null) {
                    model.addRow(String.format("%s::%d", seriesInfo.getDatabase(), seriesInfo.getId()), metaObject, originalName, file);
                }
            } else if (metaObject instanceof Movie) {
                Movie movie = (Movie)metaObject;
                if (movie.getTmdbId() > 0) {
                    model.addRow(String.format("%s::%d", "TheMovieDB", movie.getTmdbId()), metaObject, originalName, file);
                } else if (movie.getImdbId() > 0) {
                    model.addRow(String.format("%s::%d", "OMDb", movie.getImdbId()), metaObject, originalName, file);
                }
            }
            if (!Thread.interrupted()) continue;
            throw new CancellationException();
        }
        return model;
    }

    @Override
    protected void setModel(TableModel model) {
        this.table.setModel(model);
    }

    private static class FileAttributesTableModel
    extends AbstractTableModel {
        private final List<Object[]> rows = new ArrayList<Object[]>();

        private FileAttributesTableModel() {
        }

        public boolean addRow(Object ... row) {
            if (row.length != this.getColumnCount()) {
                return false;
            }
            return this.rows.add(row);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Meta ID";
                }
                case 1: {
                    return "Meta Attributes";
                }
                case 2: {
                    return "Original Name";
                }
                case 3: {
                    return "File Path";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex)[columnIndex];
        }
    }
}

