/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.filebot.ResourceManager;
import net.filebot.UserFiles;
import net.filebot.ui.PanelBuilder;
import net.filebot.ui.filter.FileTreeCellRenderer;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.util.FilterIterator;
import net.filebot.util.TreeIterator;
import net.filebot.util.ui.SwingEventBus;
import net.filebot.util.ui.SwingUI;

public class FileTree
extends JTree {
    public FileTree() {
        super(new DefaultTreeModel(new FolderNode()));
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new FileTreeCellRenderer());
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setRowHeight(22);
        this.setLargeModel(true);
        this.addMouseListener(new ExpandCollapsePopupListener());
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public List<File> getRoot() {
        FolderNode model = (FolderNode)this.getModel().getRoot();
        return model.getChildren().stream().map(node -> {
            if (node instanceof FolderNode) {
                FolderNode folder = (FolderNode)node;
                return folder.getFile();
            }
            if (node instanceof FileNode) {
                FileNode file = (FileNode)node;
                return file.getFile();
            }
            return null;
        }).collect(Collectors.toList());
    }

    public void clear() {
        this.getModel().setRoot(new FolderNode());
        this.getModel().reload();
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public void collapseAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.collapseRow(row);
        }
    }

    public static class FolderNode
    extends AbstractTreeNode {
        private final File file;
        private final String title;
        private final List<TreeNode> children;

        public FolderNode() {
            this(Collections.emptyList());
        }

        public FolderNode(List<TreeNode> children) {
            this(null, "/", children);
        }

        public FolderNode(String title, List<TreeNode> children) {
            this(null, title, children);
        }

        public FolderNode(File file, String title, List<TreeNode> children) {
            this.file = file;
            this.title = title;
            this.children = children;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.title;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        public Iterator<TreeNode> treeIterator() {
            return new TreeIterator<TreeNode>(new TreeNode[]{this}){

                @Override
                protected Iterator<TreeNode> children(TreeNode node) {
                    if (node instanceof FolderNode) {
                        return ((FolderNode)node).getChildren().iterator();
                    }
                    return null;
                }
            };
        }

        public Iterator<File> fileIterator() {
            return new FilterIterator<TreeNode, File>(this.treeIterator()){

                @Override
                protected File filter(TreeNode node) {
                    if (node instanceof FileNode) {
                        return ((FileNode)node).getFile();
                    }
                    return null;
                }
            };
        }
    }

    public static class FileNode
    extends AbstractTreeNode {
        private final File file;

        public FileNode(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    public static class AbstractTreeNode
    implements TreeNode {
        private TreeNode parent;

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return null;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public int getIndex(TreeNode node) {
            return -1;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }

    private class ExpandCollapsePopupListener
    extends MouseAdapter {
        private ExpandCollapsePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TreePath path = FileTree.this.getPathForLocation(e.getX(), e.getY());
                if (!FileTree.this.getSelectionModel().isPathSelected(path)) {
                    FileTree.this.setSelectionPath(path);
                }
                OpenExpandCollapsePopup popup = new OpenExpandCollapsePopup();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class OpenExpandCollapsePopup
    extends JPopupMenu {
        public OpenExpandCollapsePopup() {
            Collection<File> selectedFiles = this.getFiles(FileTree.this.getSelectionPaths());
            if (selectedFiles != null && !selectedFiles.isEmpty()) {
                JMenu menu = new JMenu("Send to");
                for (PanelBuilder panel : PanelBuilder.fileHandlerSequence()) {
                    menu.add(new JMenuItem(new ImportAction(panel, selectedFiles)));
                }
                this.add(menu);
                this.addSeparator();
            }
            if (selectedFiles.size() > 0) {
                this.add(new JMenuItem(new RevealAction("Reveal", selectedFiles)));
                this.add(new RevealAction("Reveal Folder", selectedFiles.stream().map(File::getParentFile).distinct().collect(Collectors.toList())));
                this.addSeparator();
            }
            this.add(SwingUI.newAction("Expand all", ResourceManager.getIcon("tree.expand"), evt -> FileTree.this.expandAll()));
            this.add(SwingUI.newAction("Collapse all", ResourceManager.getIcon("tree.collapse"), evt -> FileTree.this.collapseAll()));
        }

        private Collection<File> getFiles(TreePath[] selection) {
            if (selection == null || selection.length == 0) {
                return Collections.emptySet();
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (TreePath path : selection) {
                this.collectFiles(path.getLastPathComponent(), files);
            }
            return files;
        }

        private void collectFiles(Object node, Collection<File> files) {
            if (node instanceof FileNode) {
                files.add(((FileNode)node).getFile());
            } else if (node instanceof FolderNode) {
                for (TreeNode it : ((FolderNode)node).getChildren()) {
                    this.collectFiles(it, files);
                }
            }
        }

        private class ImportAction
        extends AbstractAction {
            private PanelBuilder panel;
            private Collection<File> files;

            public ImportAction(PanelBuilder panel, Collection<File> files) {
                super(panel.getName(), panel.getIcon());
                this.panel = panel;
                this.files = files;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingEventBus.getInstance().post(this.panel);
                SwingUI.invokeLater(200, () -> SwingEventBus.getInstance().post(new FileTransferable(this.files)));
            }
        }

        private class RevealAction
        extends AbstractAction {
            private Collection<File> files;

            public RevealAction(String text, Collection<File> files) {
                super(text);
                this.files = files;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                UserFiles.revealFiles(this.files);
            }
        }
    }
}

