/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.filebot.ResourceManager;
import net.filebot.UserFiles;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

class ConflictDialog
extends JDialog {
    private ConflictTableModel model = new ConflictTableModel();
    private boolean cancel = true;

    public ConflictDialog(Window owner, List<Conflict> conflicts) {
        super(owner, "Conflicting Files", Dialog.ModalityType.DOCUMENT_MODAL);
        this.model.setData(conflicts);
        JTable table = new JTable(this.model);
        table.setDefaultRenderer(File.class, new FileRenderer());
        table.setFillsViewportHeight(true);
        table.setAutoCreateRowSorter(true);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoResizeMode(2);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(false);
        table.setSelectionMode(0);
        table.getColumnModel().getColumn(0).setMaxWidth(40);
        table.setRowHeight(25);
        table.setPreferredScrollableViewportSize(new Dimension(500, 250));
        table.addMouseListener(new OpenListener());
        this.setBackground(Color.WHITE);
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new MigLayout("insets dialog, nogrid, fill", "", "[fill][pref!]"));
        c.add((Component)new JScrollPane(table), "grow, wrap");
        c.add((Component)SwingUI.newButton("Cancel", ResourceManager.getIcon("dialog.cancel"), this::cancel), "tag left");
        c.add((Component)SwingUI.newButton("Continue", ResourceManager.getIcon("dialog.continue"), this::ignore), "tag ok");
        JButton b = SwingUI.newButton("Override", ResourceManager.getIcon("dialog.continue.invalid"), this::override);
        b.setEnabled(conflicts.stream().anyMatch(it -> it.override));
        b.addActionListener(evt -> b.setEnabled(false));
        c.add((Component)b, "tag next");
        SwingUtilities.invokeLater(c.getComponent(2)::requestFocusInWindow);
        SwingUI.installAction(c, KeyStroke.getKeyStroke(27, 0), SwingUI.newAction("Cancel", this::cancel));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(365, 280));
        this.pack();
    }

    public boolean cancel() {
        return this.cancel;
    }

    public List<Conflict> getConflicts() {
        return this.model.getData();
    }

    private void override(ActionEvent evt) {
        List<Conflict> data = this.model.getData().stream().map(c -> {
            if (!c.override) {
                return c;
            }
            try {
                UserFiles.trash(c.destination);
            }
            catch (Exception e) {
                return new Conflict(c.source, c.destination, Collections.singletonList(e.getMessage()), false);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.model.setData(data);
        if (data.isEmpty()) {
            this.ignore(evt);
        }
    }

    public void ignore(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
    }

    public void cancel(ActionEvent evt) {
        this.cancel = true;
        this.setVisible(false);
    }

    public static boolean check(Component parent, Map<File, File> renameMap) {
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        HashSet destFiles = new HashSet();
        renameMap.forEach((from, to) -> {
            ArrayList<Object> issues = new ArrayList<Object>();
            boolean override = false;
            if (FileUtilities.getExtension(to = FileUtilities.resolve(from, to)) == null && to.isFile()) {
                issues.add("Missing extension");
            }
            if (!destFiles.add(to)) {
                issues.add("Duplicate destination path");
            }
            if (renameMap.containsKey(to) && !to.equals(from)) {
                issues.add("Conflict with source path");
            }
            if (to.exists() && !to.equals(from)) {
                issues.add("File already exists");
                boolean bl = override = issues.size() == 1;
            }
            if (issues.size() > 0) {
                conflicts.add(new Conflict((File)from, (File)to, (List<Object>)issues, override));
            }
        });
        if (conflicts.isEmpty()) {
            return true;
        }
        ConflictDialog dialog = new ConflictDialog(SwingUI.getWindow(parent), conflicts);
        dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
        dialog.setVisible(true);
        if (dialog.cancel()) {
            return false;
        }
        for (Conflict it : dialog.getConflicts()) {
            renameMap.remove(it.source);
        }
        return true;
    }

    private static class OpenListener
    extends MouseAdapter {
        private OpenListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JTable table;
            int row;
            if (evt.getClickCount() == 2 && (row = (table = (JTable)evt.getSource()).getSelectedRow()) >= 0) {
                ConflictTableModel m = (ConflictTableModel)table.getModel();
                Conflict c = (Conflict)m.getData().get(row);
                List<File> files = Stream.of(c.source, c.destination).filter(File::exists).distinct().collect(Collectors.toList());
                UserFiles.revealFiles(files);
            }
        }
    }

    private static class FileRenderer
    extends DefaultTableCellRenderer {
        private FileRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            File f = (File)value;
            super.getTableCellRendererComponent(table, f.getName(), isSelected, hasFocus, row, column);
            this.setToolTipText(f.getPath());
            return this;
        }
    }

    private static class ConflictTableModel
    extends AbstractTableModel {
        private Conflict[] data = new Conflict[0];

        private ConflictTableModel() {
        }

        public void setData(List<Conflict> data) {
            this.data = data.toArray(new Conflict[0]);
            this.fireTableDataChanged();
        }

        private List<Conflict> getData() {
            return Collections.unmodifiableList(Arrays.asList(this.data));
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Issue";
                }
                case 2: {
                    return "Source";
                }
                case 3: {
                    return "Destination";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return File.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Conflict conflict = this.data[row];
            switch (column) {
                case 0: {
                    return ResourceManager.getIcon(conflict.issues.isEmpty() ? "status.ok" : "status.error");
                }
                case 1: {
                    return conflict.issues.isEmpty() ? "OK" : conflict.issues.stream().map(Objects::toString).collect(Collectors.joining(" \u2022 "));
                }
                case 2: {
                    return conflict.source;
                }
                case 3: {
                    return conflict.destination;
                }
            }
            return null;
        }
    }

    public static class Conflict {
        public final File source;
        public final File destination;
        public final List<Object> issues;
        public final boolean override;

        public Conflict(File source, File destination, List<Object> issues, boolean override) {
            this.source = source;
            this.destination = destination;
            this.issues = issues;
            this.override = override;
        }
    }
}

