/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.io.File;
import java.text.Format;
import java.util.Map;
import java.util.logging.Level;
import javax.script.ScriptException;
import net.filebot.ApplicationFolder;
import net.filebot.Logging;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.MediaBindingBean;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.MatchFormatter;
import net.filebot.util.FileUtilities;

class ExpressionFormatter
implements MatchFormatter {
    private final String expression;
    private ExpressionFileFormat format;
    private Format preview;
    private Class<?> target;

    public ExpressionFormatter(String expression, Format preview, Class<?> target) {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("Expression must not be null or empty");
        }
        this.expression = expression;
        this.preview = preview;
        this.target = target;
    }

    public ExpressionFormatter(ExpressionFileFormat format, Format preview, Class<?> target) {
        this(format.getExpression(), preview, target);
        this.format = format;
    }

    public Class<?> getTargetClass() {
        return this.target;
    }

    @Override
    public boolean canFormat(Match<?, ?> match) {
        return this.target.isInstance(match.getValue()) && (match.getCandidate() == null || match.getCandidate() instanceof File);
    }

    @Override
    public String preview(Match<?, ?> match) {
        return this.preview != null ? this.preview.format(match.getValue()) : match.getValue().toString();
    }

    @Override
    public synchronized String format(Match<?, ?> match, boolean extension, Map<?, ?> context) throws ScriptException {
        if (this.format == null) {
            this.format = new ExpressionFileFormat(this.expression);
        }
        MediaBindingBean bindingBean = new MediaBindingBean(match.getValue(), (File)match.getCandidate(), context);
        String destination = this.format.format(bindingBean);
        return this.getPath((File)match.getCandidate(), destination);
    }

    private String getPath(File source, String destination) {
        if (source == null) {
            return destination;
        }
        File parent = new File(destination).getParentFile();
        if (parent == null || parent.isAbsolute() || destination.startsWith(".")) {
            return destination;
        }
        if (destination.startsWith("~")) {
            return ApplicationFolder.UserHome.resolve(destination.substring(1)).getAbsolutePath();
        }
        try {
            File structureRoot = MediaDetection.getStructureRoot(source);
            if (structureRoot != null) {
                for (File f : FileUtilities.listPath(parent)) {
                    if (MediaDetection.isVolumeRoot(structureRoot)) break;
                    if (!MediaDetection.isStructureRoot(f)) continue;
                    structureRoot = structureRoot.getParentFile();
                }
                return new File(structureRoot, destination).getAbsolutePath();
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to resolve structure root: " + source, e);
        }
        return destination;
    }
}

