/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.similarity.EpisodeMetrics;
import net.filebot.similarity.Matcher;
import net.filebot.ui.rename.RenameModel;
import net.filebot.util.ui.ProgressMonitor;
import net.filebot.util.ui.SwingUI;

class MatchAction
extends AbstractAction {
    private final RenameModel model;

    public MatchAction(RenameModel model) {
        this.model = model;
        this.setMatchMode(false);
    }

    public void setMatchMode(boolean strict) {
        this.putValue("Name", "Match");
        this.putValue("SmallIcon", ResourceManager.getIcon(strict ? "action.match.strict" : "action.match"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.model.names().isEmpty() || this.model.files().isEmpty()) {
            return;
        }
        SwingUI.withWaitCursor(evt.getSource(), () -> {
            try {
                Matcher matcher = new Matcher(this.model.values(), this.model.candidates(), false, EpisodeMetrics.defaultSequence(true));
                List matches = ProgressMonitor.runTask("Match", "Finding optimal alignment. This may take a while.", (message, progress, cancelled) -> {
                    message.accept(String.format("Checking %d combinations...", matcher.remainingCandidates().size() * matcher.remainingValues().size()));
                    return matcher.match();
                }).get();
                this.model.clear();
                this.model.addAll(matches);
                this.model.addAll(matcher.remainingValues(), matcher.remainingCandidates());
            }
            catch (CancellationException e) {
                Logging.debug.finest(e::toString);
            }
            catch (Throwable e) {
                Logging.log.log(Level.WARNING, e.getMessage(), e);
            }
        });
    }
}

