/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.Settings;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.CommonSequenceMatcher;
import net.filebot.similarity.Match;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.Normalization;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.ui.rename.OriginalOrder;
import net.filebot.ui.rename.TextColorizer;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Movie;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MoviePart;
import net.filebot.web.SortOrder;

class MovieMatcher
implements AutoCompleteMatcher {
    private MovieIdentificationService service;
    private Set<AutoSelection> autoSelectionMode = EnumSet.noneOf(AutoSelection.class);
    private Map<String, Movie> selectionMemory = new TreeMap<Object, Movie>(CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH));
    private Map<String, String> inputMemory = new TreeMap<Object, String>(CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH));

    public MovieMatcher(MovieIdentificationService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Match<File, ?>> match(Collection<File> files, boolean strict, SortOrder sortOrder, Locale locale, boolean autodetect, Component parent) throws Exception {
        if (files.isEmpty()) {
            return this.justFetchMovieInfo(locale, parent);
        }
        ArrayList<File> fileset = autodetect ? FileUtilities.filter(files, FileUtilities.not(MediaDetection.getClutterFileFilter())) : new ArrayList<File>(files);
        TreeSet<File> movieFiles = new TreeSet<File>(FileUtilities.filter(fileset, MediaTypes.VIDEO_FILES));
        TreeSet<File> nfoFiles = new TreeSet<File>(FileUtilities.filter(fileset, MediaTypes.NFO_FILES));
        ArrayList<File> orphanedFiles = new ArrayList<File>(FileUtilities.filter(fileset, FileUtilities.FILES));
        orphanedFiles.removeAll(movieFiles);
        orphanedFiles.removeAll(nfoFiles);
        HashMap derivatesByMovieFile = new HashMap();
        for (File movieFile : movieFiles) {
            derivatesByMovieFile.put(movieFile, new ArrayList());
        }
        block6: for (File file : orphanedFiles) {
            Iterator<File> orphanParent = FileUtilities.listPath(file);
            for (File movieFile : movieFiles) {
                if (!orphanParent.contains(movieFile.getParentFile()) || !FileUtilities.isDerived(file, movieFile)) continue;
                ((List)derivatesByMovieFile.get(movieFile)).add(file);
                continue block6;
            }
        }
        for (List derivates : derivatesByMovieFile.values()) {
            orphanedFiles.removeAll(derivates);
        }
        TreeMap<File, Movie> movieByFile = new TreeMap<File, Movie>();
        TreeSet<File> effectiveNfoFileSet = new TreeSet<File>((Collection<File>)nfoFiles);
        for (File dir : FileUtilities.mapByFolder(movieFiles).keySet()) {
            effectiveNfoFileSet.addAll(FileUtilities.getChildren(dir, MediaTypes.NFO_FILES));
        }
        for (File dir : FileUtilities.filter(fileset, FileUtilities.FOLDERS)) {
            effectiveNfoFileSet.addAll(FileUtilities.getChildren(dir, MediaTypes.NFO_FILES));
        }
        for (File nfo : effectiveNfoFileSet) {
            try {
                Movie movie2 = MediaDetection.grepMovie(nfo, this.service, locale);
                if (movie2 == null) continue;
                if (nfoFiles.contains(nfo)) {
                    movieByFile.put(nfo, movie2);
                }
                if (MediaDetection.isDiskFolder(nfo.getParentFile())) {
                    for (File folder : fileset) {
                        if (!nfo.getParentFile().equals(folder)) continue;
                        movieByFile.put(folder, movie2);
                    }
                    continue;
                }
                TreeSet<File> siblingMovieFiles = new TreeSet<File>(FileUtilities.filter(movieFiles, new FileUtilities.ParentFilter(nfo.getParentFile())));
                String baseName = MediaDetection.stripReleaseInfo(FileUtilities.getName(nfo)).toLowerCase();
                Iterator<Object> iterator = siblingMovieFiles.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    if (baseName.isEmpty() || !MediaDetection.stripReleaseInfo(FileUtilities.getName(file)).toLowerCase().startsWith(baseName)) continue;
                    movieByFile.put(file, movie2);
                }
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, "Failed to grep IMDbID: " + nfo.getName(), e);
            }
        }
        ArrayList<File> movieMatchFiles = new ArrayList<File>();
        movieMatchFiles.addAll(movieFiles);
        movieMatchFiles.addAll(nfoFiles);
        movieMatchFiles.addAll(FileUtilities.filter(files, FileUtilities.FOLDERS));
        movieMatchFiles.addAll(FileUtilities.filter(orphanedFiles, MediaTypes.SUBTITLE_FILES));
        ExecutorService workerThreadPool = Executors.newFixedThreadPool(Settings.getPreferredThreadPoolSize());
        try {
            List tasks = movieMatchFiles.stream().filter(f -> movieByFile.get(f) == null).map(f -> workerThreadPool.submit(() -> {
                if (strict) {
                    List<Integer> year = MediaDetection.parseMovieYear(FileUtilities.getRelativePathTail(f, 3).getPath());
                    if (year.isEmpty() || MediaDetection.isEpisode(f, true)) {
                        return Collections.EMPTY_MAP;
                    }
                    return Collections.singletonMap(f, MediaDetection.detectMovie(f, this.service, locale, strict).stream().filter(m -> year.contains(m.getYear())).collect(Collectors.toList()));
                }
                return Collections.singletonMap(f, MediaDetection.detectMovie(f, this.service, locale, strict));
            })).collect(Collectors.toList());
            for (Future future : tasks) {
                for (Map.Entry entry : ((Map)future.get()).entrySet()) {
                    File file = (File)entry.getKey();
                    List options = (List)entry.getValue();
                    Movie movie3 = this.grabMovieName(file, options, strict, locale, autodetect, parent);
                    if ((movie3 = MediaDetection.getLocalizedMovie(this.service, movie3, locale)) == null) continue;
                    movieByFile.put(file, movie3);
                }
            }
        }
        finally {
            workerThreadPool.shutdownNow();
        }
        Map filesByMovie = movieByFile.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, LinkedHashMap::new, Collectors.mapping(Map.Entry::getKey, Collectors.toCollection(TreeSet::new))));
        ArrayList matches = new ArrayList();
        filesByMovie.forEach((movie, fs) -> MediaDetection.groupByMediaCharacteristics(fs).forEach(moviePartFiles -> {
            for (int i = 0; i < moviePartFiles.size(); ++i) {
                Movie moviePart = moviePartFiles.size() == 1 ? movie : new MoviePart((Movie)movie, i + 1, moviePartFiles.size());
                matches.add(new Match(moviePartFiles.get(i), moviePart.clone()));
                List derivates = (List)derivatesByMovieFile.get(moviePartFiles.get(i));
                if (derivates == null) continue;
                for (File derivate : derivates) {
                    matches.add(new Match<File, Movie>(derivate, moviePart.clone()));
                }
            }
        }));
        matches.sort(Comparator.comparing(Match::getValue, OriginalOrder.of(files)));
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Movie grabMovieName(File movieFile, Collection<Movie> options, boolean strict, Locale locale, boolean autodetect, Component parent) throws Exception {
        Map<String, Movie> map = this.selectionMemory;
        synchronized (map) {
            if (!(strict || autodetect && !options.isEmpty() || autodetect && this.autoSelectionMode.size() > 0)) {
                String suggestion = options.isEmpty() ? MediaDetection.stripReleaseInfo(FileUtilities.getName(movieFile)) : options.iterator().next().getName();
                String input = this.inputMemory.get(suggestion);
                if (input == null || suggestion == null || suggestion.isEmpty()) {
                    File movieFolder = MediaDetection.guessMovieFolder(movieFile);
                    Component component = parent;
                    synchronized (component) {
                        input = SwingUI.showInputDialog(this.getQueryInputMessage("Please identify the following files:", "Enter movie name:", movieFile), suggestion != null && suggestion.length() > 0 ? suggestion : FileUtilities.getName(movieFile), movieFolder == null ? movieFile.getName() : String.join((CharSequence)" / ", movieFolder.getName(), movieFile.getName()), parent);
                    }
                    this.inputMemory.put(suggestion, input);
                }
                if (input != null && input.length() > 0 && (options = this.service.searchMovie(input, locale)).size() > 0) {
                    return this.selectMovie(movieFile, strict, input, options, parent);
                }
            }
        }
        return options.isEmpty() ? null : this.selectMovie(movieFile, strict, null, options, parent);
    }

    protected String getQueryInputMessage(String header, String message, File file) throws Exception {
        File path;
        StringBuilder html = new StringBuilder(512);
        html.append("<html>");
        if (header != null) {
            html.append(SwingUI.escapeHTML(header)).append("<br>");
        }
        if ((path = MediaDetection.getStructurePathTail(file)) == null) {
            path = FileUtilities.getRelativePathTail(file, 3);
        }
        TextColorizer colorizer = new TextColorizer("<nobr>\u2022 ", "</nobr><br>");
        colorizer.colorizePath(html, path, file.isFile());
        html.append("<br>");
        if (message != null) {
            html.append(SwingUI.escapeHTML(message));
        }
        html.append("</html>");
        return html.toString();
    }

    protected String checkedStripReleaseInfo(File file, boolean strict) throws Exception {
        Movie match;
        String name = MediaDetection.stripReleaseInfo(FileUtilities.getName(file));
        if (name.length() < 2 && (match = MediaDetection.checkMovie(file, strict)) != null) {
            return match.getName();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Movie selectMovie(File movieFile, boolean strict, String userQuery, Collection<Movie> options, Component parent) throws Exception {
        String folderQuery;
        if (options.size() == 1) {
            return options.iterator().next();
        }
        String fileQuery = userQuery != null ? userQuery : this.checkedStripReleaseInfo(movieFile, strict);
        File movieFolder = MediaDetection.guessMovieFolder(movieFile);
        String string = folderQuery = userQuery != null || movieFolder == null ? "" : this.checkedStripReleaseInfo(movieFolder, strict);
        if (userQuery == null && fileQuery.length() < 2 && folderQuery.length() < 2) {
            return null;
        }
        for (Movie movie : options) {
            String movieIdentifier = Normalization.normalizePunctuation(movie.toString()).toLowerCase();
            if (!fileQuery.toLowerCase().startsWith(movieIdentifier) && !folderQuery.toLowerCase().startsWith(movieIdentifier)) continue;
            return movie;
        }
        LinkedList<Movie> probableMatches = new LinkedList<Movie>();
        NameSimilarityMetric metric = new NameSimilarityMetric();
        float threshold = 0.9f;
        for (Movie result : options) {
            float maxSimilarity = 0.0f;
            for (String query : new String[]{fileQuery, folderQuery}) {
                for (String name : strict ? result.getEffectiveNames() : result.getEffectiveNamesWithoutYear()) {
                    if (maxSimilarity >= threshold) continue;
                    maxSimilarity = Math.max(maxSimilarity, metric.getSimilarity(query, name));
                }
            }
            if (!(maxSimilarity >= threshold)) continue;
            probableMatches.add(result);
        }
        if (probableMatches.size() == 1) {
            return (Movie)probableMatches.get(0);
        }
        if (strict) {
            return null;
        }
        FutureTask<Movie> showSelectDialog = new FutureTask<Movie>(() -> {
            String query = fileQuery.length() >= 2 || folderQuery.length() <= 2 ? fileQuery : folderQuery;
            JLabel header = new JLabel(this.getQueryInputMessage("Failed to identify some of the following files:", null, movieFile));
            header.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            SelectDialog selectDialog = new SelectDialog(parent, options, true, false, header);
            selectDialog.setTitle(this.service.getName());
            selectDialog.getMessageLabel().setText("<html>Select best match for \"<b>" + SwingUI.escapeHTML(query) + "</b>\":</html>");
            selectDialog.getCancelAction().putValue("Name", "Skip");
            selectDialog.pack();
            selectDialog.restoreState(Preferences.userNodeForPackage(MovieMatcher.class));
            selectDialog.setLocation(SwingUI.getOffsetLocation(selectDialog.getOwner()));
            selectDialog.setVisible(true);
            selectDialog.saveState(Preferences.userNodeForPackage(MovieMatcher.class));
            if (selectDialog.getAutoRepeatCheckBox().isSelected() || selectDialog.getSelectedAction() == null) {
                this.autoSelectionMode.add(selectDialog.getSelectedValue() == null ? AutoSelection.Skip : AutoSelection.First);
            }
            if (selectDialog.getSelectedAction() == null) {
                throw new CancellationException();
            }
            return (Movie)selectDialog.getSelectedValue();
        });
        Map<String, Movie> map = this.selectionMemory;
        synchronized (map) {
            String selectionKey;
            String string2 = selectionKey = fileQuery.length() >= 2 || folderQuery.length() <= 2 ? fileQuery : folderQuery;
            if (this.selectionMemory.containsKey(selectionKey)) {
                return this.selectionMemory.get(selectionKey);
            }
            if (this.autoSelectionMode.contains((Object)AutoSelection.First)) {
                return options.iterator().next();
            }
            if (this.autoSelectionMode.contains((Object)AutoSelection.Skip)) {
                return null;
            }
            Component component = parent;
            synchronized (component) {
                SwingUtilities.invokeAndWait(showSelectDialog);
                this.selectionMemory.put(selectionKey, (Movie)showSelectDialog.get());
                return (Movie)showSelectDialog.get();
            }
        }
    }

    public List<Match<File, ?>> justFetchMovieInfo(Locale locale, Component parent) throws Exception {
        String input = SwingUI.showInputDialog("Enter movie name:", "", "Fetch Movie Info", parent);
        ArrayList matches = new ArrayList();
        if (input != null && input.length() > 0) {
            for (Movie movie : MediaDetection.detectMovie(new File(input), this.service, locale, false)) {
                if ((movie = MediaDetection.getLocalizedMovie(this.service, movie, locale)) == null) continue;
                matches.add(new Match<Object, Movie>(null, movie));
            }
        }
        return matches;
    }

    private static enum AutoSelection {
        First,
        Skip;

    }
}

