/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import net.filebot.MediaTypes;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.util.FileUtilities;
import net.filebot.web.AudioTrack;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.SortOrder;

class MusicMatcher
implements AutoCompleteMatcher {
    private MusicIdentificationService[] services;

    public MusicMatcher(MusicIdentificationService ... services) {
        this.services = services;
    }

    @Override
    public List<Match<File, ?>> match(Collection<File> files, boolean strict, SortOrder order, Locale locale, boolean autodetection, Component parent) throws Exception {
        ArrayList matches = new ArrayList();
        LinkedHashSet<File> remaining = new LinkedHashSet<File>(FileUtilities.filter(files, MediaTypes.AUDIO_FILES, MediaTypes.VIDEO_FILES));
        for (int i = 0; i < this.services.length && remaining.size() > 0; ++i) {
            this.services[i].lookup(remaining).forEach((k, v) -> {
                if (v != null) {
                    matches.add(new Match<File, AudioTrack>((File)k, v.clone()));
                    remaining.remove(k);
                }
            });
        }
        return matches;
    }
}

