/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import net.filebot.HistorySpooler;
import net.filebot.Logging;
import net.filebot.NativeRenameAction;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.StandardRenameAction;
import net.filebot.UserFiles;
import net.filebot.media.MediaDetection;
import net.filebot.media.XattrMetaInfo;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.ConflictDialog;
import net.filebot.ui.rename.RenameModel;
import net.filebot.ui.rename.ValidateDialog;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.ProgressMonitor;
import net.filebot.util.ui.SwingUI;

class RenameAction
extends AbstractAction {
    public static final String RENAME_ACTION = "RENAME_ACTION";
    private final RenameModel model;

    public RenameAction(RenameModel model) {
        this.model = model;
        this.resetValues();
    }

    public void resetValues() {
        this.putValue(RENAME_ACTION, StandardRenameAction.MOVE);
        this.putValue("Name", "Rename");
        this.putValue("SmallIcon", ResourceManager.getIcon("action.rename"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.model.names().isEmpty() || this.model.files().isEmpty()) {
            Logging.log.info("Nothing to rename. New Names is empty. Please <Fetch Data> first.");
            return;
        }
        Window window = SwingUI.getWindow(evt.getSource());
        SwingUI.withWaitCursor(window, () -> {
            Map<File, File> renameMap = this.validate(this.model.getRenameMap(), window);
            if (renameMap.isEmpty()) {
                return;
            }
            ArrayList<Match<Object, File>> matches = new ArrayList<Match<Object, File>>(this.model.matches());
            StandardRenameAction action = (StandardRenameAction)this.getValue(RENAME_ACTION);
            LinkedHashMap<File, File> renameLog = new LinkedHashMap<File, File>();
            try {
                if (Settings.useNativeShell() && NativeRenameAction.isSupported(action)) {
                    NativeRenameWorker worker = new NativeRenameWorker(renameMap, renameLog, NativeRenameAction.valueOf(action.name()));
                    worker.call((Consumer)null, (BiConsumer)null, (Supplier)null);
                } else {
                    StandardRenameWorker worker = new StandardRenameWorker(renameMap, renameLog, action);
                    String message = String.format("%s %d %s. This may take a while.", action.getDisplayVerb(), renameMap.size(), renameMap.size() == 1 ? "file" : "files");
                    ProgressMonitor.runTask(action.getDisplayName(), message, worker).get();
                }
            }
            catch (CancellationException e) {
                Logging.debug.finest(e::toString);
            }
            catch (Throwable e) {
                Logging.log.log(Level.SEVERE, e, Logging.cause(ExceptionUtilities.getRootCause(e)));
            }
            if (renameLog.isEmpty()) {
                return;
            }
            Logging.log.info(String.format("%d files renamed.", renameLog.size()));
            renameLog.forEach((from, to) -> this.model.matches().remove(this.model.files().indexOf(from)));
            HistorySpooler.getInstance().append(renameLog.entrySet());
            this.storeMetaInfo(renameMap, matches);
            if (action == StandardRenameAction.MOVE) {
                this.deleteEmptyFolders(renameLog);
            }
        });
    }

    private void storeMetaInfo(Map<File, File> renameMap, List<Match<Object, File>> matches) {
        for (Match<Object, File> match : matches) {
            File file = match.getCandidate();
            Object info = match.getValue();
            File destination = renameMap.get(file);
            if (info == null || destination == null || !(destination = FileUtilities.resolve(file, destination)).isFile()) continue;
            String original = file.getName();
            Logging.debug.finest(Logging.format("Store xattr: [%s, %s] => %s", info, original, destination));
            XattrMetaInfo.xattr.setMetaInfo(destination, info, original);
        }
    }

    private void deleteEmptyFolders(Map<File, File> renameMap) {
        TreeSet deleteFiles = new TreeSet();
        renameMap.forEach((s, d) -> {
            File sourceFolder = s.getParentFile();
            File destinationFolder = FileUtilities.resolve(s, d).getParentFile();
            if (d.getParentFile() == null || destinationFolder.getPath().startsWith(sourceFolder.getPath())) {
                return;
            }
            try {
                int tailSize = MediaDetection.listStructurePathTail(d.getParentFile()).size();
                for (int i = 0; i < tailSize && !MediaDetection.isStructureRoot(sourceFolder); ++i) {
                    File[] children = sourceFolder.listFiles();
                    if (children == null || !Arrays.stream(children).allMatch(f -> deleteFiles.contains(f) || FileUtilities.isThumbnailStore(f))) {
                        return;
                    }
                    Arrays.stream(children).forEach(deleteFiles::add);
                    deleteFiles.add(sourceFolder);
                    sourceFolder = sourceFolder.getParentFile();
                }
            }
            catch (Exception e) {
                Logging.debug.warning(e::toString);
            }
        });
        try {
            for (File file : deleteFiles) {
                if (!file.exists()) continue;
                UserFiles.trash(file);
            }
        }
        catch (Throwable e) {
            Logging.debug.log(Level.WARNING, e, e::getMessage);
        }
    }

    private Map<File, File> validate(final Map<File, File> renameMap, Window parent) {
        AbstractList<File> destinationPathView = new AbstractList<File>(){
            private File[] keyIndex;
            {
                this.keyIndex = renameMap.keySet().toArray(new File[0]);
            }

            @Override
            public File get(int i) {
                return (File)renameMap.get(this.keyIndex[i]);
            }

            @Override
            public File set(int i, File value) {
                return renameMap.put(this.keyIndex[i], value);
            }

            @Override
            public int size() {
                return this.keyIndex.length;
            }
        };
        if (ValidateDialog.validate(parent, (List<File>)destinationPathView)) {
            if (Settings.isMacSandbox() && !MacAppUtilities.askUnlockFolders(parent, renameMap.entrySet().stream().flatMap(e -> Stream.of((File)e.getKey(), FileUtilities.resolve((File)e.getKey(), (File)e.getValue()))).collect(Collectors.toList()))) {
                return Collections.emptyMap();
            }
            if (ConflictDialog.check(parent, renameMap)) {
                return renameMap;
            }
        }
        return Collections.emptyMap();
    }

    protected static class NativeRenameWorker
    implements ProgressMonitor.ProgressWorker<Map<File, File>> {
        private Map<File, File> renameMap;
        private Map<File, File> renameLog;
        private NativeRenameAction action;

        public NativeRenameWorker(Map<File, File> renameMap, Map<File, File> renameLog, NativeRenameAction action) {
            this.renameMap = renameMap;
            this.renameLog = renameLog;
            this.action = action;
        }

        @Override
        public Map<File, File> call(Consumer<String> message, BiConsumer<Long, Long> progress, Supplier<Boolean> cancelled) throws Exception {
            LinkedHashMap<File, File> renamePlan = new LinkedHashMap<File, File>();
            this.renameMap.forEach((from, to) -> {
                if (!FileUtilities.equalsCaseSensitive(from, to = FileUtilities.resolve(from, to))) {
                    renamePlan.put((File)from, (File)to);
                }
            });
            try {
                this.action.rename(renamePlan);
            }
            catch (CancellationException e) {
                Logging.debug.finest(e::getMessage);
            }
            this.renameMap.forEach((from, to) -> {
                if (FileUtilities.resolve(from, to).exists()) {
                    this.renameLog.put((File)from, (File)to);
                }
            });
            return this.renameLog;
        }
    }

    protected static class StandardRenameWorker
    implements ProgressMonitor.ProgressWorker<Map<File, File>> {
        private Map<File, File> renameMap;
        private Map<File, File> renameLog;
        private StandardRenameAction action;

        public StandardRenameWorker(Map<File, File> renameMap, Map<File, File> renameLog, StandardRenameAction action) {
            this.renameMap = renameMap;
            this.renameLog = renameLog;
            this.action = action;
        }

        @Override
        public Map<File, File> call(Consumer<String> message, BiConsumer<Long, Long> progress, Supplier<Boolean> cancelled) throws Exception {
            for (Map.Entry<File, File> mapping : this.renameMap.entrySet()) {
                if (cancelled.get().booleanValue()) {
                    return this.renameLog;
                }
                message.accept(mapping.getKey().getName());
                File source = mapping.getKey();
                File destination = FileUtilities.resolve(mapping.getKey(), mapping.getValue());
                if (!FileUtilities.equalsCaseSensitive(source, destination)) {
                    this.action.rename(source, destination);
                }
                this.renameLog.put(mapping.getKey(), mapping.getValue());
            }
            return this.renameLog;
        }
    }
}

