/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.ui.rename.CharacterHighlightPainter;
import net.filebot.ui.rename.HighlightListCellRenderer;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

class ValidateDialog
extends JDialog {
    private JList list;
    private File[] model;
    private boolean cancel = true;
    private final Action validateAction = new AbstractAction("Validate", ResourceManager.getIcon("dialog.continue")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (int i = 0; i < ValidateDialog.this.model.length; ++i) {
                ((ValidateDialog)ValidateDialog.this).model[i] = FileUtilities.validateFilePath(ValidateDialog.this.model[i]);
            }
            ValidateDialog.this.list.repaint();
            ValidateDialog.this.continueAction.putValue("SmallIcon", this.getValue("SmallIcon"));
            this.setEnabled(false);
        }
    };
    private final Action continueAction = SwingUI.newAction("Continue", ResourceManager.getIcon("dialog.continue.invalid"), evt -> this.finish(false));
    private final Action cancelAction = SwingUI.newAction("Cancel", ResourceManager.getIcon("dialog.cancel"), evt -> this.finish(true));

    public ValidateDialog(Window owner, Collection<File> source) {
        super(owner, "Illegal Characters", Dialog.ModalityType.DOCUMENT_MODAL);
        this.model = source.toArray(new File[0]);
        this.list = new JList<File>(this.model);
        this.list.setEnabled(false);
        this.list.setCellRenderer(new IllegalCharactersListCellRenderer());
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new MigLayout("insets dialog, nogrid, fill", "", "[fill][pref!]"));
        c.add((Component)new JScrollPane(this.list), "grow, wrap");
        c.add((Component)new JButton(this.cancelAction), "tag left");
        c.add((Component)new JButton(this.validateAction), "tag next");
        c.add((Component)new JButton(this.continueAction), "tag ok");
        SwingUtilities.invokeLater(c.getComponent(2)::requestFocusInWindow);
        SwingUI.installAction(c, KeyStroke.getKeyStroke(27, 0), this.cancelAction);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(365, 280));
        this.pack();
    }

    public List<File> getModel() {
        return Collections.unmodifiableList(Arrays.asList(this.model));
    }

    public boolean cancel() {
        return this.cancel;
    }

    private void finish(boolean cancel) {
        this.cancel = cancel;
        this.setVisible(false);
    }

    public static boolean validate(Component parent, List<File> source) {
        IndexView<File> invalidFilePaths = new IndexView<File>(source);
        for (int i = 0; i < source.size(); ++i) {
            if (!FileUtilities.isInvalidFilePath(source.get(i)) || Settings.isUnixFS()) continue;
            invalidFilePaths.addIndex(i);
        }
        if (invalidFilePaths.isEmpty()) {
            return true;
        }
        ValidateDialog dialog = new ValidateDialog(SwingUI.getWindow(parent), invalidFilePaths);
        dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
        dialog.setVisible(true);
        if (dialog.cancel()) {
            return false;
        }
        List<File> validatedFilePaths = dialog.getModel();
        for (int i = 0; i < invalidFilePaths.size(); ++i) {
            invalidFilePaths.set(i, validatedFilePaths.get(i));
        }
        return true;
    }

    private static class IndexView<E>
    extends AbstractList<E> {
        private List<Integer> mapping = new ArrayList<Integer>();
        private List<E> source;

        public IndexView(List<E> source) {
            this.source = source;
        }

        public boolean addIndex(int index) {
            return this.mapping.add(index);
        }

        @Override
        public E get(int index) {
            int sourceIndex = this.mapping.get(index);
            return sourceIndex >= 0 ? (E)this.source.get(sourceIndex) : null;
        }

        @Override
        public E set(int index, E element) {
            return this.source.set(this.mapping.get(index), element);
        }

        @Override
        public int size() {
            return this.mapping.size();
        }
    }

    private static class IllegalCharactersListCellRenderer
    extends HighlightListCellRenderer {
        public IllegalCharactersListCellRenderer() {
            super(FileUtilities.ILLEGAL_CHARACTERS, new CharacterHighlightPainter(new Color(16728576), new Color(16716288)), 4);
        }

        @Override
        protected void updateHighlighter() {
            this.textComponent.getHighlighter().removeAllHighlights();
            Matcher matcher = this.pattern.matcher(this.textComponent.getText());
            File file = new File(this.textComponent.getText());
            for (File element : FileUtilities.listPath(file)) {
                int limit = element.getPath().length();
                matcher.region(limit - element.getName().length(), limit);
                while (matcher.find()) {
                    try {
                        this.textComponent.getHighlighter().addHighlight(matcher.start(0), matcher.end(0), this.highlightPainter);
                    }
                    catch (BadLocationException e) {
                        Logging.debug.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }
}

