/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.filebot.Settings;
import net.filebot.util.DefaultThreadFactory;

class ChecksumComputationService {
    public static final String TASK_COUNT_PROPERTY = "taskCount";
    private final Set<ThreadPoolExecutor> executors = new HashSet<ThreadPoolExecutor>(4);
    private final AtomicInteger completedTaskCount = new AtomicInteger(0);
    private final AtomicInteger totalTaskCount = new AtomicInteger(0);
    private final int threadPoolSize = Settings.getPreferredThreadPoolSize();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    ChecksumComputationService() {
    }

    public ExecutorService newExecutor() {
        return new ChecksumComputationExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Set<ThreadPoolExecutor> set = this.executors;
        synchronized (set) {
            for (ExecutorService executorService : this.executors) {
                for (Runnable runnable : executorService.shutdownNow()) {
                    if (!(runnable instanceof Future)) continue;
                    ((Future)((Object)runnable)).cancel(false);
                }
            }
            this.totalTaskCount.set(0);
            this.completedTaskCount.set(0);
            this.executors.clear();
        }
        this.pcs.firePropertyChange(TASK_COUNT_PROPERTY, -1, this.getTaskCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        Set<ThreadPoolExecutor> set = this.executors;
        synchronized (set) {
            return this.executors.size();
        }
    }

    public int getTaskCount() {
        return this.totalTaskCount.get() - this.completedTaskCount.get();
    }

    public int getTotalTaskCount() {
        return this.totalTaskCount.get();
    }

    public int getCompletedTaskCount() {
        return this.completedTaskCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Set<ThreadPoolExecutor> set = this.executors;
        synchronized (set) {
            for (ThreadPoolExecutor executor : this.executors) {
                executor.purge();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private class ChecksumComputationExecutor
    extends ThreadPoolExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChecksumComputationExecutor() {
            super(1, ChecksumComputationService.this.threadPoolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory("ChecksumComputationPool", 1));
            Set set = ChecksumComputationService.this.executors;
            synchronized (set) {
                if (ChecksumComputationService.this.executors.add(this) && ChecksumComputationService.this.executors.size() == 1) {
                    ChecksumComputationService.this.totalTaskCount.set(0);
                    ChecksumComputationService.this.completedTaskCount.set(0);
                }
            }
            this.prestartAllCoreThreads();
        }

        protected int getPreferredPoolSize() {
            return (int)Math.max(1L, Math.round(Math.sqrt(ChecksumComputationService.this.threadPoolSize) + Math.log10(this.getQueue().size()) - 1.0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            int preferredPoolSize = this.getPreferredPoolSize();
            if (this.getCorePoolSize() < preferredPoolSize) {
                this.setCorePoolSize(preferredPoolSize);
            }
            ChecksumComputationExecutor checksumComputationExecutor = this;
            synchronized (checksumComputationExecutor) {
                super.execute(command);
            }
            ChecksumComputationService.this.totalTaskCount.incrementAndGet();
            ChecksumComputationService.this.pcs.firePropertyChange(ChecksumComputationService.TASK_COUNT_PROPERTY, this.getTaskCount() - 1L, this.getTaskCount());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purge() {
            int delta = 0;
            ChecksumComputationExecutor checksumComputationExecutor = this;
            synchronized (checksumComputationExecutor) {
                delta += this.getQueue().size();
                super.purge();
            }
            if ((delta -= this.getQueue().size()) > 0) {
                ChecksumComputationService.this.totalTaskCount.addAndGet(-delta);
                ChecksumComputationService.this.pcs.firePropertyChange(ChecksumComputationService.TASK_COUNT_PROPERTY, this.getTaskCount() + (long)delta, this.getTaskCount());
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (this.isValid()) {
                if (r instanceof Future && ((Future)((Object)r)).isCancelled()) {
                    ChecksumComputationService.this.totalTaskCount.decrementAndGet();
                } else {
                    ChecksumComputationService.this.completedTaskCount.incrementAndGet();
                }
                ChecksumComputationService.this.pcs.firePropertyChange(ChecksumComputationService.TASK_COUNT_PROPERTY, this.getTaskCount() + 1L, this.getTaskCount());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isValid() {
            Set set = ChecksumComputationService.this.executors;
            synchronized (set) {
                return ChecksumComputationService.this.executors.contains(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void terminated() {
            Set set = ChecksumComputationService.this.executors;
            synchronized (set) {
                ChecksumComputationService.this.executors.remove(this);
            }
        }
    }
}

