/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import net.filebot.hash.HashType;
import net.filebot.ui.sfv.ChecksumCell;
import net.filebot.ui.sfv.ChecksumRow;
import net.filebot.util.FastFile;
import net.filebot.util.FileUtilities;

class ChecksumTableModel
extends AbstractTableModel {
    private final IndexedMap<String, ChecksumRow> rows = new IndexedMap<String, ChecksumRow>(){

        @Override
        public String key(ChecksumRow value) {
            return value.getName();
        }
    };
    private final List<File> checksumColumns = new ArrayList<File>(4);
    public static final String HASH_TYPE_PROPERTY = "hashType";
    private HashType hashType = HashType.SFV;
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int row = ChecksumTableModel.this.getRowIndex((ChecksumRow)evt.getSource());
            if (row >= 0) {
                ChecksumTableModel.this.fireTableRowsUpdated(row, row);
            }
        }
    };
    private final PropertyChangeListener progressListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ChecksumCell cell = (ChecksumCell)evt.getSource();
            int row = ChecksumTableModel.this.getRowIndex(cell);
            int column = ChecksumTableModel.this.getColumnIndex(cell);
            if (row >= 0 && column >= 0) {
                ChecksumTableModel.this.fireTableCellUpdated(row, column);
            }
        }
    };
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    ChecksumTableModel() {
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "State";
            }
            case 1: {
                return "Name";
            }
        }
        return FileUtilities.getFolderName(this.getColumnRoot(columnIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ChecksumRow.State.class;
            }
            case 1: {
                return String.class;
            }
        }
        return ChecksumCell.class;
    }

    protected int getColumnIndex(ChecksumCell cell) {
        int index = this.checksumColumns.indexOf(cell.getRoot());
        if (index < 0) {
            return -1;
        }
        return index + 2;
    }

    public File getColumnRoot(int columnIndex) {
        return this.checksumColumns.get(columnIndex - 2);
    }

    public boolean isVerificationColumn(int columnIndex) {
        return columnIndex >= 2 && this.getColumnRoot(columnIndex).isFile();
    }

    public List<File> getChecksumColumns() {
        return Collections.unmodifiableList(this.checksumColumns);
    }

    @Override
    public int getColumnCount() {
        return this.checksumColumns.size() + 2;
    }

    protected int getRowIndex(ChecksumRow row) {
        return this.rows.getIndexByKey(row.getName());
    }

    protected int getRowIndex(ChecksumCell cell) {
        return this.rows.getIndexByKey(cell.getName());
    }

    public List<ChecksumRow> rows() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public void setHashType(HashType hashType) {
        HashType old = this.hashType;
        this.hashType = hashType;
        this.fireTableDataChanged();
        this.pcs.firePropertyChange(HASH_TYPE_PROPERTY, (Object)old, (Object)hashType);
    }

    public HashType getHashType() {
        return this.hashType;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ChecksumRow row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getState();
            }
            case 1: {
                return row.getName();
            }
        }
        ChecksumCell cell = row.getChecksum(this.getColumnRoot(columnIndex));
        if (cell == null) {
            return null;
        }
        switch (cell.getState()) {
            case READY: {
                return cell.getChecksum(this.hashType);
            }
            case ERROR: {
                return cell.getError();
            }
        }
        return cell.getTask();
    }

    public void addAll(Collection<ChecksumCell> values) {
        ArrayList<ChecksumCell> replacements = new ArrayList<ChecksumCell>();
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        for (ChecksumCell cell : values) {
            ChecksumRow row;
            int rowIndex = this.getRowIndex(cell);
            if (rowIndex >= 0) {
                row = this.rows.get(rowIndex);
            } else {
                row = new ChecksumRow(cell.getName());
                row.addPropertyChangeListener(this.stateListener);
                this.rows.add(row);
            }
            ChecksumCell old = row.put(cell);
            if (old != null) {
                old.dispose();
                replacements.add(cell);
            }
            cell.addPropertyChangeListener(this.progressListener);
            if (this.checksumColumns.contains(cell.getRoot())) continue;
            this.checksumColumns.add(new FastFile(cell.getRoot()));
        }
        if (columnCount != this.getColumnCount()) {
            this.fireTableStructureChanged();
            return;
        }
        for (ChecksumCell replacement : replacements) {
            int row = this.getRowIndex(replacement);
            this.fireTableRowsUpdated(row, row);
        }
        if (rowCount != this.getRowCount()) {
            this.fireTableRowsInserted(rowCount, this.getRowCount() - 1);
        }
    }

    public void remove(int ... index) {
        Arrays.sort(index);
        for (int i : index) {
            this.rows.get(i).dispose();
        }
        this.rows.removeAll(index);
        this.fireTableRowsDeleted(index[0], index[index.length - 1]);
    }

    public void clear() {
        this.checksumColumns.clear();
        this.rows.clear();
        this.fireTableStructureChanged();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected static abstract class IndexedMap<K, V>
    extends AbstractList<V> {
        private final Map<K, Integer> indexMap = new HashMap<K, Integer>(64);
        private final List<V> list = new ArrayList<V>(64);

        protected IndexedMap() {
        }

        public abstract K key(V var1);

        @Override
        public V get(int index) {
            return this.list.get(index);
        }

        public int getIndexByKey(K key) {
            Integer index = this.indexMap.get(key);
            if (index == null) {
                return -1;
            }
            return index;
        }

        @Override
        public boolean add(V value) {
            K key = this.key(value);
            Integer index = this.indexMap.get(key);
            if (index == null && this.list.add(value)) {
                this.indexMap.put(key, this.lastIndexOf(value));
                return true;
            }
            return false;
        }

        public void removeAll(int ... index) {
            Arrays.sort(index);
            for (int i = index.length - 1; i >= 0; --i) {
                V value = this.list.remove(index[i]);
                this.indexMap.remove(this.key(value));
            }
            this.updateIndexMap();
        }

        private void updateIndexMap() {
            for (int i = 0; i < this.list.size(); ++i) {
                this.indexMap.put(this.key(this.list.get(i)), i);
            }
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
            this.indexMap.clear();
        }
    }
}

