/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.awt.Component;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.filebot.ui.sfv.ChecksumRow;

class HighlightPatternCellRenderer
extends DefaultTableCellRenderer {
    private final Pattern pattern;

    public HighlightPatternCellRenderer(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        boolean isError = EnumSet.of(ChecksumRow.State.ERROR, ChecksumRow.State.WARNING).contains(table.getValueAt(row, 0));
        Matcher matcher = this.pattern.matcher(String.valueOf(value));
        StringBuffer htmlText = new StringBuffer("<html><nobr>");
        while (matcher.find()) {
            matcher.appendReplacement(htmlText, this.createReplacement(isSelected ? null : (isError ? "red" : "#009900"), "smaller", isError ? "bold" : null));
        }
        matcher.appendTail(htmlText).append("</nobr></html>");
        this.setText(htmlText.toString());
        return this;
    }

    protected String createReplacement(String cssColor, String cssFontSize, String cssFontWeight) {
        StringBuilder replacement = new StringBuilder(60);
        replacement.append("<span style='");
        if (cssColor != null) {
            replacement.append("color:").append(cssColor).append(';');
        }
        if (cssFontSize != null) {
            replacement.append("font-size:").append(cssFontSize).append(';');
        }
        if (cssFontWeight != null) {
            replacement.append("font-weight:").append(cssFontWeight).append(';');
        }
        return replacement.append("'>$0</span>").toString();
    }
}

