/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.UserFiles;
import net.filebot.subtitle.SubtitleFormat;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.ui.subtitle.MemoryFileListExportHandler;
import net.filebot.ui.subtitle.SubtitleFileChooser;
import net.filebot.ui.subtitle.SubtitlePackage;
import net.filebot.ui.subtitle.SubtitlePackageCellRenderer;
import net.filebot.ui.subtitle.SubtitleViewer;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.ListView;
import net.filebot.util.ui.SwingUI;
import net.filebot.vfs.MemoryFile;
import net.miginfocom.swing.MigLayout;

class SubtitleDownloadComponent
extends JComponent {
    private EventList<SubtitlePackage> packages = new BasicEventList<SubtitlePackage>();
    private EventList<MemoryFile> files = new BasicEventList<MemoryFile>();
    private SubtitlePackageCellRenderer renderer = new SubtitlePackageCellRenderer();
    private JTextField filterEditor = new JTextField();
    private final Action clearFilterAction = new AbstractAction("Clear Filter", ResourceManager.getIcon("edit.clear")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SubtitleDownloadComponent.this.filterEditor.setText("");
        }
    };
    private final MouseListener packageListMouseHandler = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                JList list = (JList)e.getSource();
                SubtitleDownloadComponent.this.fetch(list.getSelectedValuesList().toArray());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Object[] selection;
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                if (index >= 0 && !list.isSelectedIndex(index)) {
                    list.setSelectedIndex(index);
                }
                if ((selection = list.getSelectedValuesList().toArray()).length > 0) {
                    JPopupMenu contextMenu = new JPopupMenu();
                    JMenuItem item = contextMenu.add(new AbstractAction("Download", ResourceManager.getIcon("package.fetch")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SubtitleDownloadComponent.this.fetch(selection);
                        }
                    });
                    item.setEnabled(this.isPending(selection));
                    contextMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private boolean isPending(Object[] selection) {
            for (Object value : selection) {
                SubtitlePackage subtitle = (SubtitlePackage)value;
                if (subtitle.getDownload().isStarted()) continue;
                return true;
            }
            return false;
        }
    };
    private final MouseListener fileListMouseHandler = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                JList list = (JList)e.getSource();
                SubtitleDownloadComponent.this.open(list.getSelectedValuesList().toArray());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Object[] selection;
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                if (index >= 0 && !list.isSelectedIndex(index)) {
                    list.setSelectedIndex(index);
                }
                if ((selection = list.getSelectedValuesList().toArray()).length > 0) {
                    JPopupMenu contextMenu = new JPopupMenu();
                    contextMenu.add(SwingUI.newAction("Preview", ResourceManager.getIcon("action.find"), evt -> SubtitleDownloadComponent.this.open(selection)));
                    contextMenu.add(SwingUI.newAction("Save As...", ResourceManager.getIcon("action.save"), evt -> SubtitleDownloadComponent.this.save(selection)));
                    contextMenu.add(SwingUI.newAction("Export...", ResourceManager.getIcon("action.export"), evt -> SubtitleDownloadComponent.this.export(selection)));
                    contextMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    };

    public SubtitleDownloadComponent() {
        final JList packageList = new JList(this.createPackageListModel());
        packageList.setFixedCellHeight(32);
        packageList.setCellRenderer(this.renderer);
        DefaultEventSelectionModel<SubtitlePackage> packageSelection = new DefaultEventSelectionModel<SubtitlePackage>(this.packages);
        packageSelection.setSelectionMode(103);
        packageList.setSelectionModel(packageSelection);
        packageList.addMouseListener(this.packageListMouseHandler);
        final ListView fileList = new ListView(this.createFileListModel()){

            @Override
            protected String convertValueToText(Object value) {
                MemoryFile file = (MemoryFile)value;
                return file.getName();
            }

            @Override
            protected Icon convertValueToIcon(Object value) {
                if (MediaTypes.SUBTITLE_FILES.accept(value.toString())) {
                    return ResourceManager.getIcon("file.subtitle");
                }
                return ResourceManager.getIcon("file.generic");
            }
        };
        DefaultEventSelectionModel<MemoryFile> fileSelection = new DefaultEventSelectionModel<MemoryFile>(this.files);
        fileSelection.setSelectionMode(103);
        fileList.setSelectionModel(fileSelection);
        MemoryFileListExportHandler memoryFileExportHandler = new MemoryFileListExportHandler();
        fileList.setTransferHandler(new DefaultTransferHandler(null, memoryFileExportHandler, memoryFileExportHandler));
        fileList.setDragEnabled(true);
        fileList.addMouseListener(this.fileListMouseHandler);
        JButton clearButton = SwingUI.createImageButton(this.clearFilterAction);
        clearButton.setOpaque(false);
        this.setLayout(new MigLayout("nogrid, fill, novisualpadding", "[fill]", "[pref!][fill]"));
        this.add((Component)new JLabel("Filter:"), "gap indent:push");
        this.add((Component)this.filterEditor, "wmin 120px, gap rel");
        this.add((Component)clearButton, "w pref!, h pref!");
        this.add((Component)new JScrollPane(packageList), "newline, hmin 80px");
        JScrollPane scrollPane = new JScrollPane(fileList);
        scrollPane.setViewportBorder(new LineBorder(fileList.getBackground()));
        this.add((Component)scrollPane, "newline, hmin max(80px, 30%)");
        SwingUI.installAction(packageList, KeyStroke.getKeyStroke(10, 0), new AbstractAction("Fetch"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubtitleDownloadComponent.this.fetch(packageList.getSelectedValuesList().toArray());
            }
        });
        SwingUI.installAction(fileList, KeyStroke.getKeyStroke(10, 0), new AbstractAction("Open"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubtitleDownloadComponent.this.open(fileList.getSelectedValuesList().toArray());
            }
        });
    }

    protected ListModel createPackageListModel() {
        TextComponentMatcherEditor<SubtitlePackage> matcherEditor = new TextComponentMatcherEditor<SubtitlePackage>(this.filterEditor, new TextFilterator<SubtitlePackage>(){

            @Override
            public void getFilterStrings(List<String> list, SubtitlePackage element) {
                list.add(element.getLanguage().getName());
                list.add(element.getName());
            }
        });
        EventList<SubtitlePackage> source = this.getPackageModel();
        source = new FilterList<SubtitlePackage>(source, matcherEditor);
        source = new ObservableElementList<SubtitlePackage>(source, GlazedLists.beanConnector(SubtitlePackage.class));
        return new DefaultEventListModel<SubtitlePackage>(source);
    }

    protected ListModel createFileListModel() {
        EventList<MemoryFile> source = this.getFileModel();
        source = new SortedList<MemoryFile>(source, new Comparator<MemoryFile>(){

            @Override
            public int compare(MemoryFile m1, MemoryFile m2) {
                return m1.getName().compareToIgnoreCase(m2.getName());
            }
        });
        return new DefaultEventListModel<MemoryFile>(source);
    }

    public void reset() {
        for (SubtitlePackage subtitle : this.packages) {
            subtitle.reset();
        }
        this.files.clear();
    }

    public EventList<SubtitlePackage> getPackageModel() {
        return this.packages;
    }

    public EventList<MemoryFile> getFileModel() {
        return this.files;
    }

    public void setLanguageVisible(boolean visible) {
        this.renderer.getLanguageLabel().setVisible(visible);
    }

    private void fetch(Object[] selection) {
        for (Object value : selection) {
            this.fetch((SubtitlePackage)value);
        }
    }

    private void fetch(final SubtitlePackage subtitle) {
        if (subtitle.getDownload().isStarted()) {
            return;
        }
        subtitle.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == SubtitlePackage.Download.Phase.DONE) {
                    try {
                        SubtitleDownloadComponent.this.files.addAll((Collection)subtitle.getDownload().get());
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (Exception e) {
                        Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e), e);
                        subtitle.reset();
                    }
                    subtitle.removePropertyChangeListener(this);
                }
            }
        });
        subtitle.getDownload().start();
    }

    private void open(Object[] selection) {
        try {
            for (Object object : selection) {
                MemoryFile file = (MemoryFile)object;
                if (!MediaTypes.SUBTITLE_FILES.accept(file.getName())) continue;
                this.open(file);
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void open(MemoryFile file) throws IOException {
        SubtitleViewer viewer = new SubtitleViewer(file.getName());
        viewer.getTitleLabel().setText("Subtitle Viewer");
        viewer.getInfoLabel().setText(file.getPath());
        viewer.setData(SubtitleUtilities.decodeSubtitles(file));
        viewer.setVisible(true);
    }

    private void save(Object[] selection) {
        try {
            for (Object object : selection) {
                MemoryFile data = (MemoryFile)object;
                File destination = UserFiles.showSaveDialogSelectFile(false, new File(FileUtilities.validateFileName(data.getName())), "Save Subtitles as ...", new ActionEvent(this, 1001, "Save"));
                if (destination == null) continue;
                FileUtilities.writeFile(data.getData(), destination);
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void export(Object[] selection) {
        try {
            File selectedOutputFolder = null;
            SubtitleFormat selectedFormat = SubtitleFormat.SubRip;
            long selectedTimingOffset = 0L;
            Charset selectedEncoding = StandardCharsets.UTF_8;
            if (Settings.isMacApp()) {
                selectedOutputFolder = UserFiles.showOpenDialogSelectFolder(null, "Export Subtitles to Folder (SubRip / UTF-8)", new ActionEvent(this, 1001, "Export"));
            } else {
                SubtitleFileChooser sfc = new SubtitleFileChooser();
                sfc.setFileSelectionMode(1);
                if (sfc.showSaveDialog(SwingUI.getWindow(this)) == 0) {
                    selectedOutputFolder = sfc.getSelectedFile();
                    selectedFormat = sfc.getSelectedFormat();
                    selectedTimingOffset = sfc.getTimingOffset();
                    selectedEncoding = sfc.getSelectedEncoding();
                }
            }
            if (selectedOutputFolder != null) {
                ArrayList<File> outputFiles = new ArrayList<File>();
                for (Object object : selection) {
                    MemoryFile file = (MemoryFile)object;
                    String name = FileUtilities.validateFileName(FileUtilities.getNameWithoutExtension(file.getName()));
                    File destination = new File(selectedOutputFolder, name + "." + selectedFormat.getFilter().extension());
                    SubtitleFormat targetFormat = selectedFormat.getFilter().accept(file.getName()) ? null : selectedFormat;
                    FileUtilities.writeFile(SubtitleUtilities.exportSubtitles(file, targetFormat, selectedTimingOffset, selectedEncoding), destination);
                    outputFiles.add(destination);
                }
                UserFiles.revealFiles(outputFiles);
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

