/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.filebot.ResourceManager;
import net.filebot.similarity.Normalization;
import net.filebot.subtitle.SubtitleElement;
import net.filebot.util.RegularExpressions;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.LazyDocumentListener;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.SeparatorBorder;
import net.miginfocom.swing.MigLayout;

public class SubtitleViewer
extends JFrame {
    private final JLabel titleLabel = new JLabel();
    private final JLabel infoLabel = new JLabel();
    private final SubtitleTableModel model = new SubtitleTableModel();
    private final JTable subtitleTable = this.createTable(this.model);
    private final JTextField filterEditor = this.createFilterEditor();
    private Color defaultFilterForeground = this.filterEditor.getForeground();
    private Color disabledFilterForeground = Color.lightGray;
    private final Action clearFilterAction = new AbstractAction("Clear Filter", ResourceManager.getIcon("edit.clear")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SubtitleViewer.this.filterEditor.setText("");
        }
    };

    public SubtitleViewer(String title) {
        super(title);
        this.titleLabel.setText(title);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        JPanel header = new JPanel(new MigLayout("insets dialog, nogrid, novisualpadding, fillx"));
        header.setBackground(Color.white);
        header.setBorder(new SeparatorBorder(1, new Color(0xB4B4B4), new Color(0xACACAC), GradientStyle.LEFT_TO_RIGHT, SeparatorBorder.Position.BOTTOM));
        header.add((Component)this.titleLabel, "wrap, h pref!");
        header.add((Component)this.infoLabel, "gap indent*2, h pref!, wrap");
        JPanel content = new JPanel(new MigLayout("fill, insets dialog, nogrid, novisualpadding", "[fill]", "[pref!][fill]"));
        content.add((Component)new JLabel("Filter:"), "gap indent:push");
        content.add((Component)this.filterEditor, "wmin 120px, gap rel");
        content.add((Component)SwingUI.createImageButton(this.clearFilterAction), "w pref!, h pref!, wrap");
        content.add((Component)new JScrollPane(this.subtitleTable), "grow");
        JComponent pane = (JComponent)this.getContentPane();
        pane.setLayout(new MigLayout("fill, novisualpadding, insets 0 0 rel 0"));
        pane.add((Component)header, "h min!, growx, dock north");
        pane.add((Component)content, "grow");
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setResizable(true);
        this.pack();
    }

    private JTable createTable(TableModel model) {
        JTable table = new JTable(model);
        table.setBackground(Color.white);
        table.setAutoCreateRowSorter(true);
        table.setFillsViewportHeight(true);
        table.setRowHeight(18);
        DefaultTableColumnModel m = (DefaultTableColumnModel)table.getColumnModel();
        m.getColumn(0).setMaxWidth(40);
        m.getColumn(1).setMaxWidth(60);
        m.getColumn(2).setMaxWidth(60);
        table.setSelectionMode(2);
        final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
        timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        table.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value == null ? null : timeFormat.format(value), isSelected, hasFocus, row, column);
            }
        });
        table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value == null ? null : Normalization.replaceSpace(value.toString(), " "), isSelected, hasFocus, row, column);
            }
        });
        SwingUI.installAction(table, KeyStroke.getKeyStroke(10, 0), SwingUI.newAction("focus", evt -> {
            this.setTableFilter(null);
            Rectangle focus = table.getCellRect(Math.max(table.getSelectedRow() - 7, 0), 0, true);
            focus.height = table.getSize().height;
            table.scrollRectToVisible(focus);
        }));
        table.addMouseListener(SwingUI.mouseClicked(evt -> {
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
                table.getActionMap().get("focus").actionPerformed(null);
            }
        }));
        return table;
    }

    private JTextField createFilterEditor() {
        JTextField editor = new JTextField(){

            @Override
            protected void processKeyEvent(KeyEvent evt) {
                int vk = evt.getKeyCode();
                if (vk == 38 || vk == 40 || vk == 10) {
                    SubtitleViewer.this.subtitleTable.dispatchEvent(evt);
                    return;
                }
                if (vk == 8 && !SubtitleViewer.this.filterEditor.getText().isEmpty() && SubtitleViewer.this.getTableFilter() == null) {
                    SubtitleViewer.this.setTableFilter(this.getText());
                    return;
                }
                super.processKeyEvent(evt);
            }
        };
        editor.getDocument().addDocumentListener(new LazyDocumentListener(0, evt -> this.setTableFilter(editor.getText())));
        return editor;
    }

    private RowFilter<?, ?> getTableFilter() {
        TableRowSorter sorter = (TableRowSorter)this.subtitleTable.getRowSorter();
        return sorter.getRowFilter();
    }

    private void setTableFilter(String filter) {
        List filterList = filter == null ? Collections.emptyList() : RegularExpressions.SPACE.splitAsStream(filter).filter(s -> s.length() > 0).map(SubtitleFilter::new).collect(Collectors.toList());
        TableRowSorter sorter = (TableRowSorter)this.subtitleTable.getRowSorter();
        sorter.setRowFilter(filterList.isEmpty() ? null : RowFilter.andFilter(filterList));
        this.filterEditor.setForeground(filterList.isEmpty() ? this.disabledFilterForeground : this.defaultFilterForeground);
    }

    public void setData(List<SubtitleElement> data) {
        this.model.setData(data);
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JLabel getInfoLabel() {
        return this.infoLabel;
    }

    private static class SubtitleTableModel
    extends AbstractTableModel {
        private List<SubtitleElement> data = Collections.emptyList();

        private SubtitleTableModel() {
        }

        public void setData(List<SubtitleElement> data) {
            this.data = new ArrayList<SubtitleElement>(data);
            this.fireTableDataChanged();
        }

        public SubtitleElement getRow(int row) {
            return this.data.get(row);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Start";
                }
                case 2: {
                    return "End";
                }
                case 3: {
                    return "Text";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Date.class;
                }
                case 2: {
                    return Date.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.getRow(row).getStart();
                }
                case 2: {
                    return this.getRow(row).getEnd();
                }
                case 3: {
                    return this.getRow(row).getText();
                }
            }
            return null;
        }
    }

    private static class SubtitleFilter
    extends RowFilter<Object, Integer> {
        private final Pattern filter;

        public SubtitleFilter(String filter) {
            this.filter = Pattern.compile(Pattern.quote(filter), 386);
        }

        @Override
        public boolean include(RowFilter.Entry<?, ? extends Integer> entry) {
            SubtitleTableModel model = (SubtitleTableModel)entry.getModel();
            SubtitleElement element = model.getRow(entry.getIdentifier());
            return this.filter.matcher(element.getText()).find();
        }
    }
}

