/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.SwingPropertyChangeSupport;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.FileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;

public abstract class BackgroundFileTransferablePolicy<V>
extends FileTransferablePolicy {
    public static final String LOADING_PROPERTY = "loading";
    private final ThreadLocal<BackgroundWorker> threadLocalWorker = new ThreadLocal();
    private final List<BackgroundWorker> workers = new ArrayList<BackgroundWorker>(2);
    protected final PropertyChangeSupport swingPropertyChangeSupport = new SwingPropertyChangeSupport(this, true);

    @Override
    public void handleTransferable(Transferable tr, TransferablePolicy.TransferAction action) throws Exception {
        List<File> files = FileTransferable.getFilesFromTransferable(tr);
        if (action != TransferablePolicy.TransferAction.ADD) {
            this.clear();
        }
        this.handleInBackground(files, action);
    }

    protected void handleInBackground(List<File> files, TransferablePolicy.TransferAction action) {
        new BackgroundWorker(files, action).execute();
    }

    @Override
    protected void clear() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<BackgroundWorker> list = this.workers;
        synchronized (list) {
            if (this.workers.size() > 0) {
                for (BackgroundWorker worker : new ArrayList<BackgroundWorker>(this.workers)) {
                    worker.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoading() {
        List<BackgroundWorker> list = this.workers;
        synchronized (list) {
            return !this.workers.isEmpty();
        }
    }

    protected abstract void process(List<V> var1);

    protected abstract void process(Exception var1);

    protected final void publish(V[] chunks) {
        BackgroundWorker worker = this.threadLocalWorker.get();
        if (worker == null) {
            throw new IllegalThreadStateException("Illegal access thread");
        }
        worker.offer(chunks);
    }

    protected final void publish(Exception exception) {
        SwingUtilities.invokeLater(() -> this.process(exception));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.swingPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.swingPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected class BackgroundWorker
    extends SwingWorker<Object, V> {
        private final List<File> files;
        private final TransferablePolicy.TransferAction action;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BackgroundWorker(List<File> files, TransferablePolicy.TransferAction action) {
            this.files = files;
            this.action = action;
            List list = BackgroundFileTransferablePolicy.this.workers;
            synchronized (list) {
                if (BackgroundFileTransferablePolicy.this.workers.add(this) && BackgroundFileTransferablePolicy.this.workers.size() == 1) {
                    BackgroundFileTransferablePolicy.this.swingPropertyChangeSupport.firePropertyChange(BackgroundFileTransferablePolicy.LOADING_PROPERTY, false, true);
                }
            }
        }

        @Override
        protected Object doInBackground() throws Exception {
            BackgroundFileTransferablePolicy.this.threadLocalWorker.set(this);
            try {
                BackgroundFileTransferablePolicy.this.load(this.files, this.action);
            }
            finally {
                BackgroundFileTransferablePolicy.this.threadLocalWorker.remove();
            }
            return null;
        }

        public void offer(V[] chunks) {
            if (!this.isCancelled()) {
                this.publish(chunks);
            }
        }

        @Override
        protected void process(List<V> chunks) {
            if (!this.isCancelled()) {
                BackgroundFileTransferablePolicy.this.process(chunks);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    this.get();
                }
                catch (Exception e) {
                    BackgroundFileTransferablePolicy.this.process(e);
                }
            }
            List list = BackgroundFileTransferablePolicy.this.workers;
            synchronized (list) {
                if (BackgroundFileTransferablePolicy.this.workers.remove(this) && BackgroundFileTransferablePolicy.this.workers.isEmpty()) {
                    BackgroundFileTransferablePolicy.this.swingPropertyChangeSupport.firePropertyChange(BackgroundFileTransferablePolicy.LOADING_PROPERTY, true, false);
                }
            }
        }
    }
}

