/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import net.filebot.Settings;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.util.FileUtilities;
import net.filebot.util.TemporaryFolder;

public class ByteBufferTransferable
implements Transferable {
    protected final Map<String, ByteBuffer> vfs;
    private FileTransferable transferable;

    public ByteBufferTransferable(Map<String, ByteBuffer> vfs) {
        this.vfs = vfs;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (FileTransferable.isFileListFlavor(flavor)) {
            try {
                if (this.transferable == null) {
                    this.transferable = this.createFileTransferable();
                }
                return this.transferable.getTransferData(flavor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected FileTransferable createFileTransferable() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (Map.Entry<String, ByteBuffer> entry : this.vfs.entrySet()) {
            String name = entry.getKey();
            ByteBuffer data = entry.getValue().duplicate();
            files.add(this.createTemporaryFile(name, data));
        }
        return new FileTransferable(files);
    }

    protected File createTemporaryFile(String name, ByteBuffer data) throws IOException {
        String validFileName = FileUtilities.validateFileName(name);
        File temporaryFile = TemporaryFolder.getFolder(Settings.getApplicationName()).subFolder("dnd").createFile(validFileName);
        FileUtilities.writeFile(data, temporaryFile);
        return temporaryFile;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, FileTransferable.uriListFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return FileTransferable.isFileListFlavor(flavor);
    }
}

