/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.filebot.ui.transfer.ClipboardHandler;
import net.filebot.ui.transfer.DefaultClipboardHandler;
import net.filebot.ui.transfer.TransferableExportHandler;
import net.filebot.ui.transfer.TransferablePolicy;

public class DefaultTransferHandler
extends TransferHandler {
    private TransferablePolicy transferablePolicy;
    private TransferableExportHandler exportHandler;
    private ClipboardHandler clipboardHandler;
    private boolean dragging = false;

    public DefaultTransferHandler(TransferablePolicy transferablePolicy, TransferableExportHandler exportHandler) {
        this(transferablePolicy, exportHandler, new DefaultClipboardHandler());
    }

    public DefaultTransferHandler(TransferablePolicy transferablePolicy, TransferableExportHandler exportHandler, ClipboardHandler clipboardHandler) {
        this.transferablePolicy = transferablePolicy;
        this.exportHandler = exportHandler;
        this.clipboardHandler = clipboardHandler;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (this.dragging) {
            return true;
        }
        if (this.transferablePolicy != null) {
            return this.transferablePolicy.canImport(support);
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.dragging) {
            return false;
        }
        if (!this.canImport(support)) {
            return false;
        }
        return this.transferablePolicy.importData(support);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        this.dragging = false;
        if (data == null) {
            return;
        }
        if (this.exportHandler != null) {
            this.exportHandler.exportDone(source, data, action);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (this.exportHandler != null) {
            return this.exportHandler.getSourceActions(c);
        }
        return 0;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.dragging = true;
        if (this.exportHandler != null) {
            return this.exportHandler.createTransferable(c);
        }
        return null;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        if (this.clipboardHandler != null) {
            this.clipboardHandler.exportToClipboard(comp, clip, action);
        }
    }

    public TransferablePolicy getTransferablePolicy() {
        return this.transferablePolicy;
    }

    public void setTransferablePolicy(TransferablePolicy transferablePolicy) {
        this.transferablePolicy = transferablePolicy;
    }

    public TransferableExportHandler getExportHandler() {
        return this.exportHandler;
    }

    public void setExportHandler(TransferableExportHandler exportHandler) {
        this.exportHandler = exportHandler;
    }

    public ClipboardHandler getClipboardHandler() {
        return this.clipboardHandler;
    }

    public void setClipboardHandler(ClipboardHandler clipboardHandler) {
        this.clipboardHandler = clipboardHandler;
    }
}

