/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JComponent;
import net.filebot.ui.transfer.FileExportHandler;
import net.filebot.ui.transfer.TextFileTransferable;
import net.filebot.ui.transfer.TransferableExportHandler;

public abstract class TextFileExportHandler
implements TransferableExportHandler,
FileExportHandler {
    @Override
    public abstract boolean canExport();

    public abstract void export(PrintWriter var1);

    @Override
    public abstract String getDefaultFileName();

    @Override
    public void export(File file) throws IOException {
        try (PrintWriter out = new PrintWriter(file, "UTF-8");){
            this.export(out);
        }
    }

    public String export() {
        StringWriter buffer = new StringWriter();
        try (PrintWriter out = new PrintWriter(buffer);){
            this.export(out);
        }
        return buffer.toString();
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.canExport() ? 3 : 0;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        return new TextFileTransferable(this.getDefaultFileName(), this.export());
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
    }
}

