/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.logging.Level;
import javax.swing.TransferHandler;
import net.filebot.Logging;

public abstract class TransferablePolicy {
    public abstract boolean accept(Transferable var1) throws Exception;

    public abstract void handleTransferable(Transferable var1, TransferAction var2) throws Exception;

    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDrop()) {
            support.setShowDropLocation(false);
        }
        try {
            return this.accept(support.getTransferable());
        }
        catch (InvalidDnDOperationException e) {
            return true;
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        Transferable transferable = support.getTransferable();
        try {
            if (this.accept(transferable)) {
                this.handleTransferable(transferable, this.getTransferAction(support));
                return true;
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e.getMessage(), e);
        }
        return false;
    }

    protected TransferAction getTransferAction(TransferHandler.TransferSupport support) {
        if (support.isDrop()) {
            return TransferAction.fromDnDConstant(support.getDropAction());
        }
        return TransferAction.PUT;
    }

    public static enum TransferAction {
        PUT(2),
        ADD(1),
        LINK(0x40000000);

        private final int dndConstant;

        private TransferAction(int dndConstant) {
            this.dndConstant = dndConstant;
        }

        public int getDnDConstant() {
            return this.dndConstant;
        }

        public static TransferAction fromDnDConstant(int dndConstant) {
            for (TransferAction action : TransferAction.values()) {
                if (dndConstant != action.dndConstant) continue;
                return action;
            }
            throw new IllegalArgumentException("Unsupported dndConstant: " + dndConstant);
        }
    }
}

