/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.filebot.util.RegularExpressions;

public final class StringUtilities {
    public static List<Integer> matchIntegers(CharSequence s) {
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        Matcher matcher = RegularExpressions.DIGIT.matcher(s);
        while (matcher.find()) {
            try {
                numbers.add(new Integer(matcher.group()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return numbers;
    }

    public static Integer matchInteger(CharSequence s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Matcher matcher = RegularExpressions.DIGIT.matcher(s);
        if (matcher.find()) {
            try {
                return new Integer(matcher.group());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Stream<String> tokenize(CharSequence s) {
        return StringUtilities.tokenize(s, RegularExpressions.SPACE);
    }

    public static Stream<String> tokenize(CharSequence s, Pattern pattern) {
        return pattern.splitAsStream(s).filter(w -> w.length() > 0);
    }

    public static Stream<String> streamMatches(CharSequence s, Pattern pattern) {
        return StringUtilities.streamMatches(s, pattern, MatchResult::group);
    }

    public static <T> Stream<T> streamMatches(CharSequence s, Pattern pattern, Function<MatchResult, T> mapper) {
        return StreamSupport.stream(new MatcherSpliterator(pattern.matcher(s)), false).map(mapper);
    }

    public static Stream<String> streamCapturingGroups(MatchResult match) {
        return IntStream.rangeClosed(1, match.groupCount()).mapToObj(match::group).filter(Objects::nonNull);
    }

    public static boolean find(String s, Pattern pattern) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return pattern.matcher(s).find();
    }

    public static Optional<String> after(String s, Pattern pattern) {
        Matcher matcher = pattern.matcher(s);
        return matcher.find() ? Optional.of(s.substring(matcher.end()).trim()) : Optional.empty();
    }

    public static String asString(Object object) {
        return object == null ? null : object.toString();
    }

    public static String asNonEmptyString(Object object) {
        String string;
        if (object != null && (string = object.toString()).length() > 0) {
            return string;
        }
        return null;
    }

    public static boolean isEmpty(Object object) {
        return object == null || object.toString().length() == 0;
    }

    public static boolean nonEmpty(Object object) {
        return object != null && object.toString().length() > 0;
    }

    public static String join(Collection<?> values, CharSequence delimiter) {
        return StringUtilities.join(values.stream(), delimiter);
    }

    public static String join(Object[] values, CharSequence delimiter) {
        return StringUtilities.join(Arrays.stream(values), delimiter);
    }

    public static String join(Stream<?> values, CharSequence delimiter) {
        return StringUtilities.join(values, delimiter, "", "");
    }

    public static String join(Stream<?> values, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return values.map(StringUtilities::asNonEmptyString).filter(Objects::nonNull).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    private StringUtilities() {
        throw new UnsupportedOperationException();
    }

    public static class MatcherSpliterator
    extends Spliterators.AbstractSpliterator<MatchResult> {
        private final Matcher m;

        public MatcherSpliterator(Matcher m) {
            super(Long.MAX_VALUE, 1296);
            this.m = m;
        }

        @Override
        public boolean tryAdvance(Consumer<? super MatchResult> f) {
            if (!this.m.find()) {
                return false;
            }
            f.accept(this.m);
            return true;
        }
    }
}

